<?php

use App\Models\HostelSetting;

if (!function_exists('hostel_setting')) {
    /**
     * Get hostel setting value by key.
     *
     * @param string|null $key
     * @param mixed $default
     * @return mixed
     */
    function hostel_setting($key = null, $default = null)
    {
        try {
            $setting = HostelSetting::getSetting();
            
            if (is_null($key)) {
                return $setting;
            }
            
            return $setting->{$key} ?? $default;
        } catch (\Exception $e) {
            return $default;
        }
    }
}

if (!function_exists('hostel_logo')) {
    /**
     * Get hostel logo URL.
     *
     * @return string
     */
    function hostel_logo()
    {
        try {
            $setting = HostelSetting::getSetting();
            return $setting->logo_url;
        } catch (\Exception $e) {
            return asset('assets/json/img/illustrations/misc-upgrade-account-illustration.png');
        }
    }
}

if (!function_exists('hostel_name')) {
    /**
     * Get hostel name.
     *
     * @return string
     */
    function hostel_name()
    {
        return hostel_setting('name', 'Gurudev Hostel');
    }
}

if (!function_exists('hostel_deposit_amount')) {
    /**
     * Get the default deposit amount.
     *
     * @return float
     */
    function hostel_deposit_amount()
    {
        return (float) hostel_setting('default_deposit_amount', 3000.00);
    }
}
