<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ExpenseHead;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class ExpenseHeadController extends Controller
{
    /**
     * Add Head form (create expense category).
     */
    public function create(): View
    {
        $heads = ExpenseHead::query()->withCount('expenses')->orderBy('name')->get(['id', 'name', 'slug']);
        return view('admin.expense-heads.create', ['heads' => $heads]);
    }

    /**
     * Store a new expense head.
     */
    public function store(Request $request): RedirectResponse
    {
        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255', 'unique:expense_heads,name'],
        ]);

        ExpenseHead::query()->create([
            'name' => $validated['name'],
        ]);

        return redirect()
            ->route('admin.expense-heads.create')
            ->with('success', 'Expense head "' . $validated['name'] . '" added successfully.');
    }
}
