<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Bed;
use App\Models\Floor;
use App\Models\Room;
use Illuminate\Http\JsonResponse;

class StudentRegistrationApiController extends Controller
{
    public function floors(): JsonResponse
    {
        $floors = Floor::query()
            ->orderBy('sort_order')
            ->orderBy('name')
            ->get(['id', 'name', 'sort_order']);
        return response()->json($floors);
    }

    public function rooms(Floor $floor): JsonResponse
    {
        $roomIds = Bed::query()
            ->where('status', Bed::STATUS_AVAILABLE)
            ->whereNull('student_id')
            ->whereHas('room', fn ($q) => $q->where('floor_id', $floor->id))
            ->pluck('room_id')
            ->unique();
        $rooms = Room::query()
            ->where('floor_id', $floor->id)
            ->whereIn('id', $roomIds)
            ->orderBy('name')
            ->get(['id', 'name', 'floor_id']);
        return response()->json($rooms);
    }

    public function beds(Room $room): JsonResponse
    {
        $beds = Bed::query()
            ->where('room_id', $room->id)
            ->where('status', Bed::STATUS_AVAILABLE)
            ->whereNull('student_id')
            ->orderBy('name')
            ->get(['id', 'name', 'room_id']);
        return response()->json($beds);
    }
}
