<?php

namespace App\Http\Controllers;

use App\Models\Enquiry;
use App\Models\HostelSetting;
use App\Models\WebsiteFeature;
use App\Models\WebsiteSetting;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Display the landing page.
     */
    public function index()
    {
        $hostelSettings = HostelSetting::getSetting();
        $websiteSettings = WebsiteSetting::getSetting();
        $features = WebsiteFeature::active()->ordered()->get();
        
        return view('home', compact('hostelSettings', 'websiteSettings', 'features'));
    }

    /**
     * Submit enquiry from landing page.
     */
    public function submitEnquiry(Request $request)
    {
        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'mobile' => ['required', 'string', 'regex:/^[0-9]{10}$/', 'max:15'],
            'email' => ['nullable', 'email', 'max:255'],
            'college' => ['nullable', 'string', 'max:255'],
            'address' => ['nullable', 'string', 'max:500'],
            'message' => ['nullable', 'string', 'max:2000'],
        ]);

        Enquiry::create([
            'name' => $validated['name'],
            'mobile' => $validated['mobile'],
            'class' => $validated['college'] ?? null,
            'address' => $validated['address'] ?? null,
            'message' => $validated['message'] ?? null,
            'status' => 'pending',
        ]);

        return redirect()->route('home')->with('success', 'Thank you for your enquiry! We will contact you soon.');
    }
}
