<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use App\Models\HostelSetting;
use App\Models\User;
use App\Services\OtpService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;

class LoginController extends Controller
{
    public function __construct(
        protected OtpService $otpService
    ) {}

    public function showLoginForm()
    {
        if (Auth::guard('user')->check()) {
            return redirect()->route('user.dashboard');
        }
        $hostelSettings = HostelSetting::getSetting();
        return view('auth.user.login', compact('hostelSettings'));
    }

    public function login(Request $request)
    {
        $request->validate([
            'username' => ['required', 'string'],
            'password' => ['required', 'string'],
        ]);

        $user = User::query()->where('email', $request->username)->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            throw ValidationException::withMessages([
                'username' => [__('auth.failed')],
            ]);
        }

        if (!$user->isUser()) {
            throw ValidationException::withMessages([
                'username' => [__('auth.failed')],
            ]);
        }

        Auth::guard('user')->login($user, $request->boolean('remember'));
        session()->forget('otp_verified_user');

        $this->otpService->generate($user, 'user');

        return redirect()->route('user.verify-otp');
    }

    public function logout(Request $request)
    {
        Auth::guard('user')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('user.login');
    }
}
