<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class AuthenticateUser
{
    public function handle(Request $request, Closure $next): Response
    {
        if (!Auth::guard('user')->check()) {
            if ($request->expectsJson()) {
                return response()->json(['message' => 'Unauthenticated.'], 401);
            }
            return redirect()->guest(route('user.login'));
        }

        $user = Auth::guard('user')->user();
        if (!$user->isUser()) {
            Auth::guard('user')->logout();
            return redirect()->guest(route('user.login'));
        }

        return $next($request);
    }
}
