<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Deposit extends Model
{
    protected $fillable = [
        'student_id', 'from_date', 'to_date', 'actual_deposit_date',
        'amount', 'payment_mode', 'transaction_id',
        'balance_amount', 'advance_amount',
    ];

    protected function casts(): array
    {
        return [
            'from_date' => 'date',
            'to_date' => 'date',
            'actual_deposit_date' => 'date',
            'amount' => 'decimal:2',
            'balance_amount' => 'decimal:2',
            'advance_amount' => 'decimal:2',
        ];
    }

    public function student(): BelongsTo
    {
        return $this->belongsTo(Student::class);
    }
}
