<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DepositReturn extends Model
{
    protected $fillable = [
        'student_id', 'amount_returned', 'return_date',
        'payment_mode', 'transaction_id', 'notes',
    ];

    protected function casts(): array
    {
        return [
            'return_date' => 'date',
            'amount_returned' => 'decimal:2',
        ];
    }

    public function student(): BelongsTo
    {
        return $this->belongsTo(Student::class);
    }
}
