<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Enquiry extends Model
{
    public const STATUS_PENDING = 'pending';
    public const STATUS_CHECKED = 'check';
    public const STATUS_DELETED = 'delete';

    protected $fillable = [
        'name',
        'mobile',
        'class',
        'address',
        'message',
        'status',
        'remark',
    ];

    public function isPending(): bool
    {
        return $this->status === self::STATUS_PENDING;
    }

    public function isChecked(): bool
    {
        return $this->status === self::STATUS_CHECKED;
    }

    public function isDeleted(): bool
    {
        return $this->status === self::STATUS_DELETED;
    }
}
