<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HostelSetting extends Model
{
    protected $fillable = [
        'name',
        'logo',
        'email',
        'phone',
        'mobile',
        'address',
        'city',
        'state',
        'pincode',
        'website',
        'description',
        'facebook',
        'instagram',
        'twitter',
        'default_deposit_amount',
    ];

    protected $casts = [
        'default_deposit_amount' => 'decimal:2',
    ];

    /**
     * Get the singleton hostel settings record.
     */
    public static function getSetting()
    {
        return static::firstOrCreate(
            ['id' => 1],
            [
                'name' => 'Gurudev Hostel',
                'email' => 'info@gurudevhostel.com',
                'phone' => '+91 1234567890',
                'default_deposit_amount' => 3000.00,
            ]
        );
    }

    /**
     * Get the logo URL.
     */
    public function getLogoUrlAttribute()
    {
        if ($this->logo) {
            return asset('storage/' . $this->logo);
        }
        return asset('assets/json/img/illustrations/misc-upgrade-account-illustration.png');
    }
}
