<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Student extends Model
{
    public const FORM_STATUS_PENDING = 'pending';
    public const FORM_STATUS_DOCUMENTS_UPLOADED = 'documents_uploaded';
    public const FORM_STATUS_BED_ALLOTTED = 'bed_allotted';
    public const FORM_STATUS_DEPOSIT_PAID = 'deposit_paid';
    public const FORM_STATUS_ACTIVE = 'active';

    public const STATUS_PENDING = 'pending';
    public const STATUS_ACTIVE = 'active';
    public const STATUS_LEFT = 'left';
    public const STATUS_CANCELLED = 'cancelled';

    protected $fillable = [
        'first_name', 'middle_name', 'last_name', 'email', 'date_of_birth',
        'permanent_locality', 'permanent_taluka', 'permanent_district', 'permanent_state',
        'student_mobile', 'parent_mobile', 'aadhar_number',
        'standard_year', 'stream', 'college_name', 'college_in_time', 'college_out_time',
        'reference_name', 'reference_relation', 'reference_contact', 'reference_by_student_id',
        'terms_accepted_at', 'form_status', 'status', 'deposit_status',
        'floor_id', 'room_id', 'bed_id', 'room_bed_identifier', 'reward_points',
    ];

    protected function casts(): array
    {
        return [
            'date_of_birth' => 'date',
            'terms_accepted_at' => 'datetime',
            'deposit_status' => 'boolean',
            'reward_points' => 'integer',
        ];
    }

    public function floor(): BelongsTo
    {
        return $this->belongsTo(Floor::class);
    }

    public function room(): BelongsTo
    {
        return $this->belongsTo(Room::class);
    }

    public function bed(): BelongsTo
    {
        return $this->belongsTo(Bed::class);
    }

    public function referenceBy(): BelongsTo
    {
        return $this->belongsTo(Student::class, 'reference_by_student_id');
    }

    public function documents(): HasMany
    {
        return $this->hasMany(StudentDocument::class);
    }

    public function bedHistory(): HasMany
    {
        return $this->hasMany(StudentBedHistory::class);
    }

    public function deposits(): HasMany
    {
        return $this->hasMany(Deposit::class);
    }

    public function agreementHistories(): HasMany
    {
        return $this->hasMany(AgreementHistory::class);
    }

    public function rents(): HasMany
    {
        return $this->hasMany(Rent::class);
    }

    public function depositReturns(): HasMany
    {
        return $this->hasMany(DepositReturn::class);
    }

    public function remarks(): HasMany
    {
        return $this->hasMany(StudentRemark::class);
    }

    public function leaves(): HasMany
    {
        return $this->hasMany(Leave::class);
    }

    public function getFullNameAttribute(): string
    {
        return collect([$this->first_name, $this->middle_name, $this->last_name])->filter()->implode(' ');
    }

    public function isActive(): bool
    {
        return $this->status === self::STATUS_ACTIVE;
    }
}
