<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class StudentBedHistory extends Model
{
    protected $table = 'student_bed_history';

    protected $fillable = ['student_id', 'floor_id', 'room_id', 'bed_id', 'allotted_at', 'left_at'];

    protected function casts(): array
    {
        return [
            'allotted_at' => 'datetime',
            'left_at' => 'datetime',
        ];
    }

    public function student(): BelongsTo
    {
        return $this->belongsTo(Student::class);
    }

    public function floor(): BelongsTo
    {
        return $this->belongsTo(Floor::class);
    }

    public function room(): BelongsTo
    {
        return $this->belongsTo(Room::class);
    }

    public function bed(): BelongsTo
    {
        return $this->belongsTo(Bed::class);
    }
}
