<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Routing\Route;

use Illuminate\Support\ServiceProvider;

class MenuServiceProvider extends ServiceProvider
{
  /**
   * Register services.
   */
  public function register(): void
  {
    //
  }

  /**
   * Bootstrap services.
   */
  public function boot(): void
  {
    $verticalMenuJson = file_get_contents(base_path('resources/menu/verticalMenu.json'));
    $verticalMenuData = json_decode($verticalMenuJson);

    $adminVerticalMenuJson = file_get_contents(base_path('resources/menu/adminVerticalMenu.json'));
    $adminVerticalMenuData = json_decode($adminVerticalMenuJson);

    // Share the appropriate menu based on current route (admin.* = admin menu)
    View::composer(['layouts.contentNavbarLayout', 'layouts.sections.menu.verticalMenu'], function ($view) use ($verticalMenuData, $adminVerticalMenuData) {
      $menuData = request()->routeIs('admin.*')
        ? [$adminVerticalMenuData]
        : [$verticalMenuData];
      $view->with('menuData', $menuData);
    });
  }
}
