<?php

return [

    'form_status' => [
        'pending' => 'Pending',
        'documents_uploaded' => 'Documents Uploaded',
        'bed_allotted' => 'Bed Allotted',
        'deposit_paid' => 'Deposit Paid',
        'active' => 'Active',
    ],

    'status' => [
        'pending' => 'Pending',
        'active' => 'Active',
        'left' => 'Left',
        'cancelled' => 'Cancelled',
    ],

    /*
    | Tab-based filters for Student Details list. Key = query param value, label = tab text.
    | Filter logic is applied in StudentRegistrationController::index().
    */
    'list_filters' => [
        'active' => 'Active',
        'pending' => 'Pending',
        'alumna' => 'Alumna',
        'not_eligible' => 'Student Not Eligible',
        'information_pending' => 'Information Pending Student',
    ],

    'document_types' => [
        'profile_photo' => 'Student Profile Photo',
        'student_aadhar' => 'Student Aadhar Card',
        'parent_aadhar' => 'Parent Aadhar Card',
        'parent_signature' => 'Parent Signature',
        'student_signature' => 'Student Signature',
    ],

    'streams' => [
        'arts' => 'Arts',
        'science' => 'Science',
        'commerce' => 'Commerce',
        'other' => 'Other',
    ],

    'payment_modes' => [
        'cash' => 'Cash',
        'upi' => 'UPI',
        'neft' => 'NEFT',
        'cheque' => 'Cheque',
        'card' => 'Card',
        'other' => 'Other',
    ],

    /*
    | Required security deposit amount (for balance/advance calculation).
    | If paid < required → balance_amount; if paid > required → advance_amount.
    */
    'required_deposit_amount' => (float) env('REQUIRED_DEPOSIT_AMOUNT', 3000),

    'document_upload' => [
        'max_size' => 5120, // 5MB in KB
        'allowed_mimes' => ['jpg', 'jpeg', 'png', 'pdf'],
    ],

    'referral_reward_points' => (int) env('REFERRAL_REWARD_POINTS', 50),

    /*
    | Minimum reward points to show "Redeem Points" (gift icon) on Add Rent form.
    | When student has >= this value, discount can be applied to rent.
    */
    'reward_points_min_for_redemption' => (int) env('REWARD_POINTS_MIN_REDEEM', 150),

    'sms_enabled' => (bool) env('SMS_ENABLED', false),
    'sms_welcome_message' => env('SMS_WELCOME_MESSAGE', 'Welcome to hostel. Your room: %s, bed: %s.'),

    'hostel_name' => env('HOSTEL_NAME', 'Shri Gurudev Boys Hostel'),
    'hostel_address' => env('HOSTEL_ADDRESS', 'Plot no. 18, Mahaveer Nagar, Near Bhajiwali Bai Putla, Peer Bazar, Osmanpura, Aurangabad (Maharashtra) - 431005'),
];
