<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('middle_name')->nullable();
            $table->string('last_name');
            $table->string('email')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('permanent_locality')->nullable();
            $table->string('permanent_taluka')->nullable();
            $table->string('permanent_district')->nullable();
            $table->string('permanent_state')->nullable();
            $table->string('student_mobile', 20)->nullable();
            $table->string('parent_mobile', 20)->nullable();
            $table->string('aadhar_number', 20)->nullable();
            $table->string('standard_year')->nullable();
            $table->string('stream')->nullable();
            $table->string('college_name')->nullable();
            $table->time('college_in_time')->nullable();
            $table->time('college_out_time')->nullable();
            $table->string('reference_name')->nullable();
            $table->string('reference_relation')->nullable();
            $table->string('reference_contact', 20)->nullable();
            $table->foreignId('reference_by_student_id')->nullable()->constrained('students')->nullOnDelete();
            $table->timestamp('terms_accepted_at')->nullable();
            $table->string('form_status', 30)->default('pending');
            $table->string('status', 20)->default('pending');
            $table->boolean('deposit_status')->default(false);
            $table->foreignId('floor_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('room_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('bed_id')->nullable()->constrained()->nullOnDelete();
            $table->string('room_bed_identifier')->nullable();
            $table->unsignedInteger('reward_points')->default(0);
            $table->timestamps();

            $table->index(['form_status', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('students');
    }
};
