<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('student_bed_history', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->cascadeOnDelete();
            $table->foreignId('floor_id')->constrained()->cascadeOnDelete();
            $table->foreignId('room_id')->constrained()->cascadeOnDelete();
            $table->foreignId('bed_id')->constrained()->cascadeOnDelete();
            $table->timestamp('allotted_at');
            $table->timestamp('left_at')->nullable();
            $table->timestamps();

            $table->index(['student_id', 'allotted_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('student_bed_history');
    }
};
