<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('hostel_settings', function (Blueprint $table) {
            $table->decimal('default_deposit_amount', 10, 2)->default(3000.00)->after('twitter');
        });

        // Update existing record with default value
        DB::table('hostel_settings')->where('id', 1)->update([
            'default_deposit_amount' => 3000.00,
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('hostel_settings', function (Blueprint $table) {
            $table->dropColumn('default_deposit_amount');
        });
    }
};
