<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            $table->decimal('balance_amount', 12, 2)->default(0)->after('transaction_id');
            $table->decimal('advance_amount', 12, 2)->default(0)->after('balance_amount');
        });
    }

    public function down(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            $table->dropColumn(['balance_amount', 'advance_amount']);
        });
    }
};
