<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('beds', function (Blueprint $table) {
            $table->decimal('rent_amount', 10, 2)->default(0)->after('name');
        });

        Schema::table('rents', function (Blueprint $table) {
            $table->decimal('balance_amount', 10, 2)->nullable()->after('amount');
            $table->decimal('advance_amount', 10, 2)->nullable()->after('balance_amount');
            $table->string('receipt_no', 50)->nullable()->after('advance_amount');
            $table->string('cheque_number', 100)->nullable()->after('transaction_id');
        });
    }

    public function down(): void
    {
        Schema::table('beds', function (Blueprint $table) {
            $table->dropColumn('rent_amount');
        });
        Schema::table('rents', function (Blueprint $table) {
            $table->dropColumn(['balance_amount', 'advance_amount', 'receipt_no', 'cheque_number']);
        });
    }
};
