<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('drawings', function (Blueprint $table) {
            $table->id();
            $table->date('drawing_date');
            $table->decimal('amount', 12, 2);
            $table->string('type', 20); // credit, debit
            $table->string('payment_mode', 50);
            $table->string('transaction_id')->nullable();
            $table->text('notes')->nullable();
            $table->foreignId('performed_by_id')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();

            $table->index('drawing_date');
            $table->index('type');
            $table->index('payment_mode');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('drawings');
    }
};
