<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('website_settings', function (Blueprint $table) {
            $table->id();
            $table->string('primary_color')->default('#696cff');
            $table->string('secondary_color')->default('#8592a3');
            $table->string('hero_title')->nullable();
            $table->text('hero_subtitle')->nullable();
            $table->string('hero_background_image')->nullable();
            $table->string('hero_background_color')->default('#667eea');
            $table->string('hero_button_text')->default('Get In Touch');
            $table->string('hero_button_link')->default('#contact');
            $table->string('about_title')->nullable();
            $table->text('about_description')->nullable();
            $table->integer('stat_residents')->default(100);
            $table->integer('stat_experience')->default(5);
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->text('custom_css')->nullable();
            $table->text('custom_js')->nullable();
            $table->timestamps();
        });

        // Insert default record
        DB::table('website_settings')->insert([
            'hero_title' => 'Gurudev Hostel',
            'hero_subtitle' => 'Your home away from home. Experience comfort, safety, and community living at its finest.',
            'about_title' => 'About Our Hostel',
            'about_description' => 'We provide a safe, comfortable, and welcoming environment for students and working professionals.',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('website_settings');
    }
};
