<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('admin_notifications', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // agreement_expiring, rent_overdue, rent_due, deposit_low, student_pending
            $table->string('priority'); // critical, warning, info, success
            $table->unsignedBigInteger('related_id'); // student_id, rent_id, etc.
            $table->string('related_type'); // Student, Rent, Deposit, etc.
            $table->string('title');
            $table->text('message');
            $table->json('meta')->nullable(); // Additional data like days, amount, etc.
            $table->string('action_url');
            $table->boolean('is_read')->default(false);
            $table->timestamp('read_at')->nullable();
            $table->timestamps();

            $table->index(['is_read', 'created_at']);
            $table->index(['type', 'is_read']);
            $table->index(['priority', 'is_read']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('admin_notifications');
    }
};
