@extends('layouts/contentNavbarLayout')

@section('title', 'Bank Deposit')

@section('vendor-style')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" />
<style>
.bank-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; }
@media print { .no-print { display: none !important; } }
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Bank Deposit</h4>
        <div class="d-flex gap-2 no-print">
            <button type="button" class="btn btn-outline-success btn-sm" id="exportExcel" title="Export Excel"><i class="ri-file-excel-2-line me-1"></i>Excel</button>
            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="window.print();" title="Print"><i class="ri-printer-line me-1"></i>Print</button>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Add Entry --}}
    <div class="card mb-4 no-print">
        <div class="card-header">
            <h5 class="card-title mb-0">Add Bank Transaction</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.bank-deposits.store') }}" method="POST">
                @csrf
                <div class="row g-3">
                    <div class="col-md-2">
                        <label class="form-label">Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('entry_date') is-invalid @enderror" name="entry_date" value="{{ old('entry_date', date('Y-m-d')) }}" required>
                        @error('entry_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Amount (₹) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('amount') is-invalid @enderror" name="amount" value="{{ old('amount') }}" min="0.01" step="0.01" required>
                        @error('amount')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Transaction Type <span class="text-danger">*</span></label>
                        <select class="form-select @error('type') is-invalid @enderror" name="type" required>
                            <option value="">— Select —</option>
                            <option value="deposit_to_bank" {{ old('type') === 'deposit_to_bank' ? 'selected' : '' }}>Deposit to Bank</option>
                            <option value="withdraw_from_bank" {{ old('type') === 'withdraw_from_bank' ? 'selected' : '' }}>Withdraw from Bank</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Payment Mode</label>
                        <select class="form-select" name="payment_mode">
                            <option value="">—</option>
                            @foreach($paymentModes as $key => $label)
                                <option value="{{ $key }}" {{ old('payment_mode') === $key ? 'selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Person Name</label>
                        <input type="text" class="form-control @error('person_name') is-invalid @enderror" name="person_name" value="{{ old('person_name') }}" placeholder="Who performed">
                        @error('person_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">UTR / Cheque No.</label>
                        <input type="text" class="form-control" name="transaction_id" value="{{ old('transaction_id') }}" placeholder="Reference">
                    </div>
                    <div class="col-md-2 align-self-end">
                        <button type="submit" class="btn btn-primary"><i class="ri-check-line me-1"></i>Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    {{-- Filters --}}
    <div class="card mb-4 no-print">
        <div class="card-body">
            <form method="get" action="{{ route('admin.bank-deposits.index') }}" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ $fromDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ $toDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Type</label>
                    <select class="form-select" name="type">
                        <option value="">All</option>
                        <option value="deposit_to_bank" {{ ($type ?? '') === 'deposit_to_bank' ? 'selected' : '' }}>Deposit to Bank</option>
                        <option value="withdraw_from_bank" {{ ($type ?? '') === 'withdraw_from_bank' ? 'selected' : '' }}>Withdraw from Bank</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Payment Mode</label>
                    <select class="form-select" name="payment_mode">
                        <option value="">All</option>
                        @foreach($paymentModes as $key => $label)
                            <option value="{{ $key }}" {{ ($paymentMode ?? '') === $key ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Search</button>
                    <a href="{{ route('admin.bank-deposits.index') }}" class="btn btn-outline-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>

    {{-- Table --}}
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table bank-table table-hover" id="bankTable">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Amount (₹)</th>
                            <th>Payment Mode</th>
                            <th>Person Name</th>
                            <th>UTR / Ref.</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($entries as $e)
                            <tr>
                                <td>{{ $e->entry_date->format('d/m/Y') }}</td>
                                <td>{{ $e->type === \App\Models\BankEntry::TYPE_DEPOSIT_TO_BANK ? 'Deposit to Bank' : 'Withdraw from Bank' }}</td>
                                <td>₹ {{ number_format($e->amount, 2) }}</td>
                                <td>{{ $paymentModes[$e->payment_mode] ?? $e->payment_mode ?? '—' }}</td>
                                <td>{{ $e->person_name ?? '—' }}</td>
                                <td>{{ $e->transaction_id ?? '—' }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="6" class="text-center text-muted py-4">No bank entries for the selected filter.</td></tr>
                        @endforelse
                    </tbody>
                    @if($entries->isNotEmpty())
                    <tfoot>
                        <tr class="table-light fw-bold">
                            <td colspan="2" class="text-end">Total</td>
                            <td>₹ {{ number_format($total, 2) }}</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tfoot>
                    @endif
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('vendor-script')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
@endsection

@section('page-script')
<script>
(function() {
    // Initialize DataTable
    $('#bankTable').DataTable({
        order: [[0, 'desc']], // Sort by Date descending
        pageLength: 25,
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ transactions",
            infoEmpty: "No transactions available",
            infoFiltered: "(filtered from _MAX_ total transactions)"
        }
    });

    var btn = document.getElementById('exportExcel');
    if (btn) btn.addEventListener('click', function() {
        var table = document.getElementById('bankTable');
        if (!table) return;
        var wb = XLSX.utils.table_to_book(table, { sheet: 'Bank Entries', raw: true });
        XLSX.writeFile(wb, 'bank-deposits-' + new Date().toISOString().slice(0,10) + '.xlsx');
    });
})();
</script>
@endsection
