@extends('layouts/contentNavbarLayout')

@section('title', 'Add Deposit')

@section('vendor-style')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Add Deposit</h4>
        <a href="{{ route('admin.deposits.create') }}" class="btn btn-outline-secondary"><i class="ri-arrow-left-line me-1"></i>Back to Deposit Details</a>
    </div>

    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.deposits.create') }}">Add Deposit</a></li>
            <li class="breadcrumb-item active">Add Deposit</li>
        </ol>
    </nav>

    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <h5 class="card-title mb-0">Deposit Details</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.deposits.store') }}" method="POST" id="addDepositForm">
                @csrf

                <div class="row g-3">
                    @if($selectedStudent)
                        {{-- From Pending list: show selected student as read-only (single field) --}}
                        <div class="col-md-6">
                            <label class="form-label">Student <span class="text-danger">*</span></label>
                            <input type="text" class="form-control bg-light" value="{{ $selectedStudent->id }} — {{ $selectedStudent->full_name }}" readonly>
                            <input type="hidden" name="student_id" value="{{ $selectedStudent->id }}">
                        </div>
                    @else
                        {{-- From top "Add Deposit" button: show student dropdown --}}
                        <div class="col-md-6">
                            <label class="form-label">Student <span class="text-danger">*</span></label>
                            <select class="form-select select2-student @error('student_id') is-invalid @enderror" name="student_id" id="student_id" required data-placeholder="— Select Student —">
                                <option value="">— Select Student —</option>
                                @foreach($students as $s)
                                    <option value="{{ $s->id }}" data-name="{{ $s->full_name }}" data-mobile="{{ $s->student_mobile ?? '' }}"
                                        {{ old('student_id') == $s->id ? 'selected' : '' }}>
                                        {{ $s->id }} — {{ $s->full_name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('student_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if($students->isEmpty())
                                <p class="form-text text-warning mb-0 mt-1">No students with pending deposit. Assign a bed first from Student Details.</p>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Student Name</label>
                            <input type="text" class="form-control bg-light" id="student_name_display" readonly placeholder="Select student above">
                        </div>
                    @endif

                    <div class="col-md-4">
                        <label class="form-label">Deposit From Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('from_date') is-invalid @enderror" name="from_date" value="{{ old('from_date') }}" required>
                        @error('from_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Deposit To Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('to_date') is-invalid @enderror" name="to_date" value="{{ old('to_date') }}" required>
                        @error('to_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Deposit Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('actual_deposit_date') is-invalid @enderror" name="actual_deposit_date" value="{{ old('actual_deposit_date', date('Y-m-d')) }}" required>
                        @error('actual_deposit_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Discount</label>
                        <input type="number" class="form-control" name="discount" value="{{ old('discount', 0) }}" min="0" step="0.01" placeholder="Enter Discount">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Deposit Amount <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('amount') is-invalid @enderror" name="amount" value="{{ old('amount') }}" min="0" step="0.01" placeholder="Enter Amount" required>
                        @error('amount')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        @php $requiredAmount = hostel_deposit_amount(); @endphp
                        <p class="form-text mb-0 mt-1" id="feesInfo">Required: ₹{{ number_format($requiredAmount, 2) }} · Balance: — Advance: —</p>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Remaining Amount</label>
                        <input type="number" class="form-control" name="remaining_amount" value="{{ old('remaining_amount', 0) }}" min="0" step="0.01" placeholder="Remaining Amount">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Advance Amount</label>
                        <input type="number" class="form-control" name="advance_amount" value="{{ old('advance_amount', 0) }}" min="0" step="0.01" placeholder="Total Amount">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Payment Type <span class="text-danger">*</span></label>
                        <select class="form-select @error('payment_mode') is-invalid @enderror" name="payment_mode" required>
                            <option value="">— Select —</option>
                            @foreach($paymentModes as $key => $label)
                                <option value="{{ $key }}" {{ old('payment_mode') === $key ? 'selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                        @error('payment_mode')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">UTR / Cheque No.</label>
                        <input type="text" class="form-control" name="transaction_id" value="{{ old('transaction_id') }}" placeholder="Optional">
                    </div>
                </div>

                <hr class="my-4">
                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary"><i class="ri-check-line me-1"></i>Submit</button>
                    <a href="{{ route('admin.deposits.create') }}" class="btn btn-danger">Close</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('page-script')
<script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
(function() {
    var requiredAmount = {{ hostel_deposit_amount() }};
    var $ = window.jQuery;
    if (!$) return;

    var sel = document.getElementById('student_id');
    var display = document.getElementById('student_name_display');
    var feesInfo = document.getElementById('feesInfo');
    var amountInput = document.querySelector('input[name="amount"]');

    function formatNum(n) { return Number(n).toLocaleString('en-IN', { minimumFractionDigits: 2, maximumFractionDigits: 2 }); }
    function updateFeesInfo() {
        if (!feesInfo || !amountInput) return;
        var amount = parseFloat(amountInput.value) || 0;
        var balance = amount < requiredAmount ? requiredAmount - amount : 0;
        var advance = amount > requiredAmount ? amount - requiredAmount : 0;
        feesInfo.textContent = 'Required: ₹' + formatNum(requiredAmount) + ' · Balance: ₹' + formatNum(balance) + ' · Advance: ₹' + formatNum(advance);
    }

    if (feesInfo && amountInput) {
        amountInput.addEventListener('input', updateFeesInfo);
        updateFeesInfo();
    }

    if (sel && display) {
        $(sel).select2({
            theme: 'bootstrap-5',
            placeholder: $(sel).data('placeholder') || '— Select Student —',
            allowClear: true,
            width: '100%'
        });
        function updateDisplay() {
            var opt = sel.options[sel.selectedIndex];
            if (opt && opt.value) {
                display.value = opt.getAttribute('data-name') || opt.text;
            } else {
                display.value = '';
            }
            updateFeesInfo();
        }
        $(sel).on('change', updateDisplay);
        updateDisplay();
    }
})();
</script>
@endsection
