@extends('layouts/contentNavbarLayout')

@section('title', 'Deposit Details')

@section('vendor-style')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" />
<style>
/* Match Users UI: stat cards, search filters, table */
.deposit-stat-card .card-body { display: flex; justify-content: space-between; align-items: flex-start; }
.deposit-stat-card .stat-icon { width: 48px; height: 48px; border-radius: 0.5rem; display: inline-flex; align-items: center; justify-content: center; font-size: 1.5rem; }
.deposit-stat-card .stat-value { font-size: 1.75rem; font-weight: 600; line-height: 1.2; }
.deposit-stat-card .stat-label { color: var(--bs-secondary); font-size: 0.875rem; margin-top: 0.25rem; }
.deposit-user-cell { display: flex; align-items: center; gap: 0.75rem; }
.deposit-user-cell .avatar-wrap { flex-shrink: 0; width: 38px; height: 38px; border-radius: 50%; overflow: hidden; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 0.875rem; background: var(--bs-secondary-bg); color: var(--bs-body-color); }
.deposit-user-cell .avatar-wrap img { width: 100%; height: 100%; object-fit: cover; }
.deposit-user-cell .user-info { min-width: 0; }
.deposit-user-cell .user-name { font-weight: 500; color: var(--bs-body-color); margin-bottom: 0.125rem; }
.deposit-user-cell .user-meta { font-size: 0.8125rem; color: var(--bs-secondary); }
.deposit-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; letter-spacing: 0.02em; }
.deposit-table .table-actions { display: flex; align-items: center; gap: 0.5rem; }
.deposit-table .table-actions .btn { padding: 0.35rem 0.5rem; }
/* Match Student Details: DataTables wrapper spacing */
#depositReceivedTable_wrapper .row:first-child,
#depositPendingTable_wrapper .row:first-child,
#depositReturnTable_wrapper .row:first-child,
#depositPendingReleaseTable_wrapper .row:first-child { margin-bottom: 1rem; }
#depositReceivedTable_wrapper .row:last-child,
#depositPendingTable_wrapper .row:last-child,
#depositReturnTable_wrapper .row:last-child,
#depositPendingReleaseTable_wrapper .row:last-child { margin-top: 1rem; }
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Deposit Details</h4>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.deposits.add') }}" class="btn btn-primary"><i class="ri-add-line me-1"></i>Add Deposit</a>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Statistics Cards (match Users UI) --}}
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-sm-6">
            <div class="card deposit-stat-card h-100">
                <div class="card-body">
                    <div>
                        <span class="stat-value d-block">{{ number_format($stats['received_count'] ?? 0) }}</span>
                        <span class="stat-label">Deposit Received</span>
                    </div>
                    <div class="stat-icon bg-label-primary"><i class="ri-bank-card-line"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="card deposit-stat-card h-100">
                <div class="card-body">
                    <div>
                        <span class="stat-value d-block">{{ number_format($stats['pending_count'] ?? 0) }}</span>
                        <span class="stat-label">Deposit Pending</span>
                    </div>
                    <div class="stat-icon bg-label-warning"><i class="ri-time-line"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="card deposit-stat-card h-100">
                <div class="card-body">
                    <div>
                        <span class="stat-value d-block">{{ number_format($stats['return_count'] ?? 0) }}</span>
                        <span class="stat-label">Deposit Return</span>
                    </div>
                    <div class="stat-icon bg-label-info"><i class="ri-refund-line"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="card deposit-stat-card h-100">
                <div class="card-body">
                    <div>
                        <span class="stat-value d-block">{{ number_format($stats['pending_release_count'] ?? 0) }}</span>
                        <span class="stat-label">Pending Release Student</span>
                    </div>
                    <div class="stat-icon bg-label-secondary"><i class="ri-user-unfollow-line"></i></div>
                </div>
            </div>
        </div>
    </div>

    {{-- Search Filters (match Users UI) --}}
    <div class="card mb-4">
        {{-- <div class="card-header">
            <h5 class="card-title mb-0">Search Filters</h5>
        </div> --}}
        <div class="card-body">
            <form method="get" action="{{ route('admin.deposits.create') }}" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ $fromDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ $toDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Payment Mode</label>
                    <select class="form-select" name="payment_mode">
                        <option value="">All</option>
                        @foreach(config('student_registration.payment_modes', []) as $key => $label)
                            <option value="{{ $key }}">{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Search Student</label>
                    <input type="text" class="form-control" name="search" placeholder="Name or mobile..." value="{{ request('search') }}">
                </div>
                <div class="col-md-3 d-flex gap-2 flex-wrap align-items-end">
                    <button type="submit" class="btn btn-primary"><i class="ri-search-line me-1"></i>Search</button>
                    <div class="dropdown">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">Export</button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" id="exportExcel"><i class="ri-file-excel-2-line me-2"></i>Excel</a></li>
                            <li><a class="dropdown-item" href="#" id="exportPdf"><i class="ri-file-pdf-line me-2"></i>PDF</a></li>
                            <li><a class="dropdown-item" href="#" id="exportPrint"><i class="ri-printer-line me-2"></i>Print</a></li>
                        </ul>
                    </div>
                </div>
            </form>
        </div>
    </div>

    {{-- Tabs --}}
    <ul class="nav nav-tabs mb-3" role="tablist">
        <li class="nav-item">
            <button type="button" class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab-received" role="tab">Deposit Received</button>
        </li>
        <li class="nav-item">
            <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-pending" role="tab">Deposit Pending</button>
        </li>
        <li class="nav-item">
            <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-return" role="tab">Deposit Return</button>
        </li>
        <li class="nav-item">
            <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-pending-release" role="tab">Deposit Pending Release Student</button>
        </li>
    </ul>

    <div class="tab-content">
        {{-- Tab: Deposit Received --}}
        <div class="tab-pane fade show active" id="tab-received" role="tabpanel">
            <div class="card">
                <div class="card-datatable table-responsive deposit-table">
                    <table class="table table-hover deposit-table" id="depositReceivedTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Deposit Date</th>
                                <th>Amount</th>
                                <th>Payment Mode</th>
                                <th>UTR / Cheque No.</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($depositsReceived as $d)
                                @php $s = $d->student; $profileDoc = $s->documents->where('document_type', 'profile_photo')->first(); @endphp
                                <tr>
                                    <td>
                                        <div class="deposit-user-cell">
                                            <div class="avatar-wrap">
                                                @if($profileDoc)
                                                    <img src="{{ asset('storage/' . $profileDoc->file_path) }}" alt="">
                                                @else
                                                    {{ strtoupper(mb_substr($s->first_name ?? '', 0, 1)) }}
                                                @endif
                                            </div>
                                            <div class="user-info">
                                                <div class="user-name">{{ $s->full_name }}</div>
                                                <div class="user-meta">{{ $s->student_mobile ?? '—' }} · ID {{ $s->id }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>{{ $d->actual_deposit_date?->format('d M Y') ?? '—' }}</td>
                                    <td>₹{{ $d->amount ? number_format($d->amount, 2) : '—' }}</td>
                                    <td>{{ $d->payment_mode ? ucfirst($d->payment_mode) : '—' }}</td>
                                    <td>{{ $d->transaction_id ?? '—' }}</td>
                                    <td><span class="badge bg-label-success">Received</span></td>
                                    <td>
                                        <div class="table-actions">
                                            <a href="{{ route('admin.students.show', $s) }}" class="btn btn-sm btn-icon btn-text-secondary" title="View"><i class="ri-eye-line"></i></a>
                                            <a href="{{ route('admin.deposits.return', $s) }}" class="btn btn-sm btn-outline-primary" title="Return Deposit">Return</a>
                                            <div class="dropdown">
                                                <button class="btn btn-sm btn-icon btn-text-secondary" type="button" data-bs-toggle="dropdown"><i class="ri-more-2-fill"></i></button>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li><a class="dropdown-item" href="{{ route('admin.students.show', $s) }}"><i class="ri-eye-line me-2"></i>View</a></li>
                                                    <li><a class="dropdown-item" href="{{ route('admin.deposits.return', $s) }}"><i class="ri-refund-line me-2"></i>Return Deposit</a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        {{-- Tab: Deposit Pending --}}
        <div class="tab-pane fade" id="tab-pending" role="tabpanel">
            <div class="card">
                <div class="card-datatable table-responsive deposit-table">
                    <table class="table table-hover deposit-table" id="depositPendingTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($depositPending as $s)
                                @php $profileDoc = $s->documents->where('document_type', 'profile_photo')->first(); @endphp
                                <tr>
                                    <td>
                                        <div class="deposit-user-cell">
                                            <div class="avatar-wrap">
                                                @if($profileDoc)
                                                    <img src="{{ asset('storage/' . $profileDoc->file_path) }}" alt="">
                                                @else
                                                    {{ strtoupper(mb_substr($s->first_name ?? '', 0, 1)) }}
                                                @endif
                                            </div>
                                            <div class="user-info">
                                                <div class="user-name">{{ $s->full_name }}</div>
                                                <div class="user-meta">{{ $s->student_mobile ?? '—' }} · ID {{ $s->id }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>—</td>
                                    <td><span class="badge bg-label-warning">Pending</span></td>
                                    <td>
                                        <div class="table-actions">
                                            <a href="{{ route('admin.students.show', $s) }}" class="btn btn-sm btn-icon btn-text-secondary" title="View"><i class="ri-eye-line"></i></a>
                                            <a href="{{ route('admin.deposits.add') }}?student_id={{ $s->id }}" class="btn btn-sm btn-warning"><i class="ri-add-line me-1"></i>Add Deposit</a>
                                            <div class="dropdown">
                                                <button class="btn btn-sm btn-icon btn-text-secondary" type="button" data-bs-toggle="dropdown"><i class="ri-more-2-fill"></i></button>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li><a class="dropdown-item" href="{{ route('admin.students.show', $s) }}"><i class="ri-eye-line me-2"></i>View</a></li>
                                                    <li><a class="dropdown-item" href="{{ route('admin.deposits.add') }}?student_id={{ $s->id }}"><i class="ri-add-line me-2"></i>Add Deposit</a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        {{-- Tab: Deposit Return --}}
        <div class="tab-pane fade" id="tab-return" role="tabpanel">
            <div class="card">
                <div class="card-datatable table-responsive deposit-table">
                    <table class="table table-hover deposit-table" id="depositReturnTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Amount</th>
                                <th>Payment Mode</th>
                                <th>UTR/Cheque No.</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($depositReturn as $dr)
                                @php $s = $dr->student; $profileDoc = $s->documents->where('document_type', 'profile_photo')->first(); @endphp
                                <tr>
                                    <td>
                                        <div class="deposit-user-cell">
                                            <div class="avatar-wrap">
                                                @if($profileDoc)
                                                    <img src="{{ asset('storage/' . $profileDoc->file_path) }}" alt="">
                                                @else
                                                    {{ strtoupper(mb_substr($s->first_name ?? '', 0, 1)) }}
                                                @endif
                                            </div>
                                            <div class="user-info">
                                                <div class="user-name">{{ $s->full_name }}</div>
                                                <div class="user-meta">{{ $s->student_mobile ?? '—' }} · ID {{ $s->id }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>₹{{ number_format($dr->amount_returned, 2) }}</td>
                                    <td>{{ ucfirst($dr->payment_mode) }}</td>
                                    <td>{{ $dr->transaction_id ?? '—' }}</td>
                                    <td>{{ $dr->return_date?->format('d M Y') ?? '—' }}</td>
                                    <td><span class="badge bg-label-info">Returned</span></td>
                                    <td>
                                        <div class="table-actions">
                                            <a href="{{ route('admin.students.show', $s) }}" class="btn btn-sm btn-icon btn-text-secondary" title="View"><i class="ri-eye-line"></i></a>
                                            <a href="{{ route('admin.students.show', $s) }}#documents" class="btn btn-sm btn-icon btn-text-secondary" title="Documents"><i class="ri-file-text-line"></i></a>
                                            <a href="{{ route('admin.students.show', $s) }}#payment-history" class="btn btn-sm btn-icon btn-text-secondary" title="Payment History"><i class="ri-bank-card-line"></i></a>
                                            <a href="{{ route('admin.students.show', $s) }}#room-history" class="btn btn-sm btn-icon btn-text-secondary" title="Room History"><i class="ri-history-line"></i></a>
                                            <div class="dropdown">
                                                <button class="btn btn-sm btn-icon btn-text-secondary" type="button" data-bs-toggle="dropdown"><i class="ri-more-2-fill"></i></button>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li><a class="dropdown-item" href="{{ route('admin.students.show', $s) }}"><i class="ri-eye-line me-2"></i>View Details</a></li>
                                                    <li><a class="dropdown-item" href="{{ route('admin.students.show', $s) }}#documents"><i class="ri-file-text-line me-2"></i>Student Documents</a></li>
                                                    <li><a class="dropdown-item" href="{{ route('admin.students.show', $s) }}#payment-history"><i class="ri-bank-card-line me-2"></i>Payment History</a></li>
                                                    <li><a class="dropdown-item" href="{{ route('admin.students.show', $s) }}#room-history"><i class="ri-history-line me-2"></i>Room History</a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="card-footer border-top">
                    <span class="text-muted small">Total: ₹{{ number_format($depositReturnTotal ?? 0, 2) }}</span>
                </div>
            </div>
        </div>

        {{-- Tab: Deposit Pending Release Student --}}
        <div class="tab-pane fade" id="tab-pending-release" role="tabpanel">
            <div class="card">
                <div class="card-datatable table-responsive deposit-table">
                    <table class="table table-hover deposit-table" id="depositPendingReleaseTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Leaving Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($depositPendingRelease as $s)
                                @php $profileDoc = $s->documents->where('document_type', 'profile_photo')->first(); @endphp
                                <tr>
                                    <td>
                                        <div class="deposit-user-cell">
                                            <div class="avatar-wrap">
                                                @if($profileDoc)
                                                    <img src="{{ asset('storage/' . $profileDoc->file_path) }}" alt="">
                                                @else
                                                    {{ strtoupper(mb_substr($s->first_name ?? '', 0, 1)) }}
                                                @endif
                                            </div>
                                            <div class="user-info">
                                                <div class="user-name">{{ $s->full_name }}</div>
                                                <div class="user-meta">{{ $s->student_mobile ?? '—' }} · ID {{ $s->id }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>{{ $s->updated_at?->format('d M Y') ?? '—' }}</td>
                                    <td><span class="badge bg-label-secondary">Left</span></td>
                                    <td>
                                        <div class="table-actions">
                                            <a href="{{ route('admin.students.show', $s) }}" class="btn btn-sm btn-icon btn-text-secondary" title="View"><i class="ri-eye-line"></i></a>
                                            <a href="{{ route('admin.deposits.return', $s) }}" class="btn btn-sm btn-warning"><i class="ri-refund-line me-1"></i>Return Deposit</a>
                                            <div class="dropdown">
                                                <button class="btn btn-sm btn-icon btn-text-secondary" type="button" data-bs-toggle="dropdown"><i class="ri-more-2-fill"></i></button>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li><a class="dropdown-item" href="{{ route('admin.students.show', $s) }}"><i class="ri-eye-line me-2"></i>View</a></li>
                                                    <li><a class="dropdown-item" href="{{ route('admin.deposits.return', $s) }}"><i class="ri-refund-line me-2"></i>Return Deposit</a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('page-script')
<script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>
(function() {
    var $ = window.jQuery || window.$;
    if (!$) return;

    // Match Student Details DataTables config
    var lang = {
        lengthMenu: 'Show _MENU_ entries',
        search: 'Search:',
        searchPlaceholder: '',
        info: 'Showing _START_ to _END_ of _TOTAL_ entries',
        infoEmpty: 'Showing 0 to 0 of 0 entries',
        infoFiltered: '(filtered from _MAX_ total entries)',
        zeroRecords: 'No matching records found',
        paginate: { first: 'First', last: 'Last', next: 'Next', previous: 'Previous' },
        processing: 'Processing...'
    };

    var defaultOpts = {
        pageLength: 10,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
        language: lang,
        processing: true,
        stateSave: false,
        dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rtip'
    };

    function initDataTable(id, orderCol, noSortCols) {
        var t = document.getElementById(id);
        if (!t) return null;
        var colDefs = [{ orderable: false, targets: -1 }];
        if (noSortCols && noSortCols.indexOf(0) !== -1) {
            colDefs.push({ orderable: false, targets: 0 });
        }
        return $(t).DataTable($.extend(true, {}, defaultOpts, {
            order: [[orderCol != null ? orderCol : 0, 'asc']],
            columnDefs: colDefs
        }));
    }

    // Init DataTable on each table (same as Student Details)
    initDataTable('depositReceivedTable', 1, [0]);   // order by Deposit Date, User & Actions not sortable
    initDataTable('depositPendingTable', 0, [0]);  // order by User, User & Actions not sortable
    initDataTable('depositReturnTable', 0, [0]);    // order by User, User & Actions not sortable
    initDataTable('depositPendingReleaseTable', 1, [0]); // order by Leaving Date, User & Actions not sortable

    function doPrint() { window.print(); }
    $(document).on('click', '#exportExcel, #exportPdf, #exportPrint', function(e) { e.preventDefault(); doPrint(); });
})();
</script>
@endsection
