@extends('layouts/blankLayout')

@section('title', 'Deposit Receipt - ' . $deposit->id)

@section('page-style')
<style>
@media print { body { -webkit-print-color-adjust: exact; print-color-adjust: exact; } .no-print { display: none !important; } }
.receipt { max-width: 640px; margin: 0 auto; font-family: system-ui, sans-serif; }
.receipt-header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 1rem; margin-bottom: 1.5rem; }
.receipt-title { font-size: 1.5rem; font-weight: 700; text-transform: uppercase; }
.receipt-meta { font-size: 0.875rem; color: #555; margin-top: 0.5rem; }
.receipt-table { width: 100%; border-collapse: collapse; margin: 1rem 0; }
.receipt-table th, .receipt-table td { padding: 0.5rem 0.75rem; text-align: left; border-bottom: 1px solid #dee2e6; }
.receipt-table th { font-weight: 600; width: 40%; color: #495057; }
.amount-words { font-style: italic; padding: 0.5rem; background: #f8f9fa; border-radius: 0.25rem; }
.receipt-footer { margin-top: 2rem; text-align: center; font-size: 0.8125rem; color: #6c757d; }
</style>
@endsection

@section('content')
<div class="receipt p-4">
    @if(empty($shareMode))
    <div class="no-print mb-3 d-flex align-items-center gap-2 flex-wrap">
        <button type="button" class="btn btn-primary btn-sm" onclick="window.print();"><i class="ri-printer-line me-1"></i>Print</button>
        <a href="{{ route('admin.receipts.deposit') }}" class="btn btn-outline-secondary btn-sm">Back to Deposit Receipt Book</a>
        @isset($pdfDownloadUrl)
            <x-share-buttons :pdf-download-url="$pdfDownloadUrl" :email-type="$emailType ?? 'deposit'" :email-id="$emailId ?? $deposit->id" />
        @endisset
    </div>
    @else
    <div class="no-print mb-3">
        <button type="button" class="btn btn-primary btn-sm" onclick="window.print();"><i class="ri-printer-line me-1"></i>Print</button>
    </div>
    @endif

    <div class="receipt-header">
        <div class="receipt-title">{{ config('app.name', 'Hostel') }}</div>
        <div class="receipt-meta">Deposit Receipt</div>
    </div>

    <table class="receipt-table">
        <tr><th>Transaction / Receipt</th><td>D-{{ $deposit->id }}</td></tr>
        <tr><th>Date</th><td>{{ $deposit->actual_deposit_date?->format('d/m/Y') ?? '—' }}</td></tr>
        <tr><th>Student ID</th><td>{{ $deposit->student_id }}</td></tr>
        <tr><th>Student Name</th><td>{{ $deposit->student->full_name ?? '—' }}</td></tr>
        @if($deposit->student && ($deposit->student->room_bed_identifier || $deposit->student->bed))
            <tr><th>Room / Bed</th><td>{{ $deposit->student->room_bed_identifier ?? ($deposit->student->bed ? $deposit->student->bed->name ?? '—' : '—') }}</td></tr>
        @endif
        <tr><th>Period</th><td>{{ $deposit->from_date?->format('d/m/Y') ?? '—' }} to {{ $deposit->to_date?->format('d/m/Y') ?? '—' }}</td></tr>
        <tr><th>Amount (₹)</th><td>{{ number_format($deposit->amount, 2) }}</td></tr>
        <tr><th>Amount in Words</th><td><div class="amount-words">{{ $amountInWords ?? '—' }}</div></td></tr>
        <tr><th>Payment Mode</th><td>{{ \Illuminate\Support\Arr::get(config('student_registration.payment_modes', []), $deposit->payment_mode, $deposit->payment_mode) }}</td></tr>
        @if($deposit->transaction_id)
            <tr><th>UTR / Transaction ID</th><td>{{ $deposit->transaction_id }}</td></tr>
        @endif
    </table>

    <div class="receipt-footer">This is a computer-generated receipt. Security deposit received.</div>
</div>
@endsection
