@extends('layouts/blankLayout')

@section('title', 'Deposit Return Receipt - ' . $depositReturn->id)

@section('page-style')
<style>
@media print { body { -webkit-print-color-adjust: exact; print-color-adjust: exact; } .no-print { display: none !important; } }
.receipt { max-width: 640px; margin: 0 auto; font-family: system-ui, sans-serif; }
.receipt-header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 1rem; margin-bottom: 1.5rem; }
.receipt-title { font-size: 1.5rem; font-weight: 700; text-transform: uppercase; }
.receipt-meta { font-size: 0.875rem; color: #555; margin-top: 0.5rem; }
.receipt-table { width: 100%; border-collapse: collapse; margin: 1rem 0; }
.receipt-table th, .receipt-table td { padding: 0.5rem 0.75rem; text-align: left; border-bottom: 1px solid #dee2e6; }
.receipt-table th { font-weight: 600; width: 40%; color: #495057; }
.amount-words { font-style: italic; padding: 0.5rem; background: #f8f9fa; border-radius: 0.25rem; }
.receipt-footer { margin-top: 2rem; text-align: center; font-size: 0.8125rem; color: #6c757d; }
</style>
@endsection

@section('content')
<div class="receipt p-4">
    @if(empty($shareMode))
    <div class="no-print mb-3 d-flex align-items-center gap-2 flex-wrap">
        <button type="button" class="btn btn-primary btn-sm" onclick="window.print();"><i class="ri-printer-line me-1"></i>Print</button>
        <a href="{{ route('admin.receipts.deposit-return') }}" class="btn btn-outline-secondary btn-sm">Back to Deposit Return Receipt Book</a>
        @isset($pdfDownloadUrl)
            <x-share-buttons :pdf-download-url="$pdfDownloadUrl" :email-type="$emailType ?? 'deposit_return'" :email-id="$emailId ?? $depositReturn->id" />
        @endisset
    </div>
    @else
    <div class="no-print mb-3">
        <button type="button" class="btn btn-primary btn-sm" onclick="window.print();"><i class="ri-printer-line me-1"></i>Print</button>
    </div>
    @endif

    <div class="receipt-header">
        <div class="receipt-title">{{ config('app.name', 'Hostel') }}</div>
        <div class="receipt-meta">Deposit Return Receipt</div>
    </div>

    <table class="receipt-table">
        <tr><th>Return Ref.</th><td>DR-{{ $depositReturn->id }}</td></tr>
        <tr><th>Return Date</th><td>{{ $depositReturn->return_date?->format('d/m/Y') ?? '—' }}</td></tr>
        <tr><th>Student ID</th><td>{{ $depositReturn->student_id }}</td></tr>
        <tr><th>Student Name</th><td>{{ $depositReturn->student->full_name ?? '—' }}</td></tr>
        <tr><th>Refund Amount (₹)</th><td>{{ number_format($depositReturn->amount_returned, 2) }}</td></tr>
        <tr><th>Amount in Words</th><td><div class="amount-words">{{ $amountInWords ?? '—' }}</div></td></tr>
        <tr><th>Mode of Refund</th><td>{{ \Illuminate\Support\Arr::get(config('student_registration.payment_modes', []), $depositReturn->payment_mode, $depositReturn->payment_mode) }}</td></tr>
        @if($depositReturn->transaction_id)
            <tr><th>UTR / Reference</th><td>{{ $depositReturn->transaction_id }}</td></tr>
        @endif
        @if($depositReturn->notes)
            <tr><th>Notes</th><td>{{ $depositReturn->notes }}</td></tr>
        @endif
    </table>

    <div class="receipt-footer">This is a computer-generated receipt. Deposit refund issued.</div>
</div>
@endsection
