@extends('layouts/contentNavbarLayout')

@section('title', 'Return Deposit - ' . $student->full_name)

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Return Deposit</h4>
        <a href="{{ route('admin.deposits.create') }}" class="btn btn-outline-secondary"><i class="ri-arrow-left-line me-1"></i>Back to Deposit Details</a>
    </div>

    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.deposits.create') }}">Deposit Details</a></li>
            <li class="breadcrumb-item active">Return Deposit</li>
        </ol>
    </nav>

    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <h5 class="card-title mb-0">Return Deposit for {{ $student->full_name }}</h5>
        </div>
        <div class="card-body">
            @if($latestDeposit)
                <p class="text-muted small mb-3">Original deposit: ₹{{ number_format($latestDeposit->amount, 2) }} ({{ $latestDeposit->actual_deposit_date?->format('d M Y') }}). Enter the amount being returned (e.g. after deductions).</p>
            @endif

            <form action="{{ route('admin.deposits.return.store') }}" method="POST">
                @csrf
                <input type="hidden" name="student_id" value="{{ $student->id }}">

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Amount Returned <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('amount_returned') is-invalid @enderror" name="amount_returned" value="{{ old('amount_returned', $latestDeposit?->amount ?? 0) }}" min="0" step="0.01" required>
                        @error('amount_returned')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Return Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('return_date') is-invalid @enderror" name="return_date" value="{{ old('return_date', date('Y-m-d')) }}" required>
                        @error('return_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Payment Mode <span class="text-danger">*</span></label>
                        <select class="form-select @error('payment_mode') is-invalid @enderror" name="payment_mode" required>
                            <option value="">— Select —</option>
                            @foreach($paymentModes as $key => $label)
                                <option value="{{ $key }}" {{ old('payment_mode') === $key ? 'selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                        @error('payment_mode')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">UTR / Cheque No.</label>
                        <input type="text" class="form-control" name="transaction_id" value="{{ old('transaction_id') }}" placeholder="Optional">
                    </div>
                    <div class="col-12">
                        <label class="form-label">Notes</label>
                        <textarea class="form-control" name="notes" rows="2" placeholder="Optional">{{ old('notes') }}</textarea>
                    </div>
                </div>

                <hr class="my-4">
                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary"><i class="ri-check-line me-1"></i>Submit Return</button>
                    <a href="{{ route('admin.deposits.create') }}" class="btn btn-danger">Close</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
