@forelse($enquiries as $e)
<tr>
    <td>{{ $e->created_at->format('d/m/Y H:i') }}</td>
    <td>{{ $e->name }}</td>
    <td>{{ $e->mobile }}</td>
    <td>{{ $e->class ?? '—' }}</td>
    <td><span class="text-truncate d-inline-block" style="max-width: 150px;" title="{{ $e->address }}">{{ $e->address ?? '—' }}</span></td>
    <td><span class="text-truncate d-inline-block" style="max-width: 180px;" title="{{ $e->message }}">{{ $e->message ?? '—' }}</span></td>
    <td>
        @if($e->status === \App\Models\Enquiry::STATUS_PENDING)
            <span class="badge bg-label-warning">Pending</span>
        @elseif($e->status === \App\Models\Enquiry::STATUS_CHECKED)
            <span class="badge bg-label-success">Checked</span>
        @else
            <span class="badge bg-label-secondary">Deleted</span>
        @endif
    </td>
    <td><span class="text-truncate d-inline-block" style="max-width: 120px;" title="{{ $e->remark }}">{{ $e->remark ?? '—' }}</span></td>
    <td>
        @if($e->status !== \App\Models\Enquiry::STATUS_DELETED)
            <div class="d-flex gap-1 flex-wrap">
                @if($e->status === \App\Models\Enquiry::STATUS_PENDING)
                    <form action="{{ route('admin.enquiries.check', $e) }}" method="POST" class="d-inline" onsubmit="return confirm('Mark as checked?');">
                        @csrf
                        <input type="hidden" name="from_date" value="{{ request('from_date') }}">
                        <input type="hidden" name="to_date" value="{{ request('to_date') }}">
                        <input type="hidden" name="status" value="{{ request('status') }}">
                        <button type="submit" class="btn btn-sm btn-outline-success" title="Mark as checked">Check</button>
                    </form>
                @endif
                <button type="button" class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#remarkModal" data-enquiry-id="{{ $e->id }}" data-enquiry-name="{{ e($e->name) }}" title="Add remark">Remark</button>
                <form action="{{ route('admin.enquiries.destroy', $e) }}" method="POST" class="d-inline" onsubmit="return confirm('Remove this enquiry from the list? (Soft delete)');">
                    @csrf
                    @method('DELETE')
                    <input type="hidden" name="from_date" value="{{ request('from_date') }}">
                    <input type="hidden" name="to_date" value="{{ request('to_date') }}">
                    <input type="hidden" name="status" value="{{ request('status') }}">
                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Remove from list">Delete</button>
                </form>
            </div>
        @else
            —
        @endif
    </td>
</tr>
@empty
<tr><td colspan="9" class="text-center text-muted py-4">No enquiries for the selected filter.</td></tr>
@endforelse
