@extends('layouts/contentNavbarLayout')

@section('title', 'Add Head')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Add Expense Head</h4>
        <a href="{{ route('admin.expenses.index') }}" class="btn btn-outline-secondary"><i class="ri-arrow-left-line me-1"></i>Expenses Details</a>
    </div>

    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.expenses.index') }}">Expenses</a></li>
            <li class="breadcrumb-item active">Add Head</li>
        </ol>
    </nav>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">New Expense Head</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.expense-heads.store') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">Head Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" placeholder="e.g. Staff Salary, Electricity & Water" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <p class="form-text mb-0 mt-1">Categories like Staff Salary, Mess/Grocery, Maintenance, etc.</p>
                        </div>
                        <button type="submit" class="btn btn-primary"><i class="ri-check-line me-1"></i>Add Head</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Existing Heads</h5>
                </div>
                <div class="card-body">
                    @if($heads->isEmpty())
                        <p class="text-muted mb-0">No expense heads yet. Add one using the form.</p>
                    @else
                        <ul class="list-group list-group-flush">
                            @foreach($heads as $h)
                                <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                    <span>{{ $h->name }}</span>
                                    <span class="badge bg-label-secondary">{{ $h->expenses_count ?? 0 }}</span>
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
