@extends('layouts/contentNavbarLayout')

@section('title', 'Hostel Settings')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">
        <span class="text-muted fw-light">Settings /</span> Hostel Settings
    </h4>

    {{-- Usage Examples:
        In Blade templates:
        - {{ $hostelSettings->name }} or {{ hostel_name() }}
        - {{ $hostelSettings->logo_url }} or {{ hostel_logo() }}
        - {{ hostel_setting('email') }}
        - {{ hostel_setting('phone') }}
        
        Example: Display logo in navbar
        <img src="{{ hostel_logo() }}" alt="{{ hostel_name() }}" />
    --}}

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-xl-12">
            <div class="card mb-6">
                <div class="card-body">
                    <form action="{{ route('admin.hostel.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PATCH')

                        {{-- Hostel Logo --}}
                        <div class="d-flex align-items-start align-items-sm-center gap-6 pb-4 border-bottom mb-6">
                            <div style="width: 120px; height: 120px; border-radius: 0.5rem; overflow: hidden; border: 2px solid var(--bs-border-color);">
                                @if($hostel->logo)
                                    <img id="hostelLogoImg" src="{{ asset('storage/' . $hostel->logo) }}" alt="Hostel Logo" style="width: 100%; height: 100%; object-fit: contain; background: #f5f5f5;">
                                @else
                                    <img id="hostelLogoImg" src="{{ asset('assets/json/img/illustrations/misc-upgrade-account-illustration.png') }}" alt="Logo" style="width: 100%; height: 100%; object-fit: contain; background: #f5f5f5;">
                                @endif
                            </div>
                            <div class="button-wrapper">
                                <label for="logoInput" class="btn btn-sm btn-primary me-3 mb-4" tabindex="0">
                                    <span class="d-none d-sm-block">Upload Hostel Logo</span>
                                    <i class="icon-base ri ri-upload-2-line d-block d-sm-none"></i>
                                    <input type="file" id="logoInput" name="logo" class="d-none" accept="image/png,image/jpeg,image/gif" />
                                </label>
                                <button type="button" class="btn btn-sm btn-outline-danger mb-4" id="logoResetBtn">
                                    <i class="icon-base ri ri-refresh-line d-block d-sm-none"></i>
                                    <span class="d-none d-sm-block">Reset</span>
                                </button>
                                <input type="hidden" name="logo_remove" id="logoRemove" value="0">
                                <div class="small">Allowed JPG, GIF or PNG. Max size of 2MB</div>
                            </div>
                        </div>

                        {{-- Basic Information --}}
                        <h6 class="mb-4">Basic Information</h6>
                        <div class="row g-5 mb-6">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="hostelName" name="name" value="{{ old('name', $hostel->name) }}" required placeholder="Hostel Name">
                                    <label for="hostelName">Hostel Name <span class="text-danger">*</span></label>
                                    @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $hostel->email) }}" placeholder="Email">
                                    <label for="email">Email</label>
                                    @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone', $hostel->phone) }}" placeholder="Phone Number">
                                    <label for="phone">Phone Number</label>
                                    @error('phone')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" class="form-control @error('mobile') is-invalid @enderror" id="mobile" name="mobile" value="{{ old('mobile', $hostel->mobile) }}" placeholder="Mobile Number">
                                    <label for="mobile">Mobile Number</label>
                                    @error('mobile')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-floating form-floating-outline">
                                    <input type="url" class="form-control @error('website') is-invalid @enderror" id="website" name="website" value="{{ old('website', $hostel->website) }}" placeholder="Website URL">
                                    <label for="website">Website URL</label>
                                    @error('website')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-floating form-floating-outline">
                                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" placeholder="Description" style="height: 100px;">{{ old('description', $hostel->description) }}</textarea>
                                    <label for="description">Description</label>
                                    @error('description')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                        </div>

                        {{-- Address Information --}}
                        <h6 class="mb-4 pt-4 border-top">Address Information</h6>
                        <div class="row g-5 mb-6">
                            <div class="col-md-12">
                                <div class="form-floating form-floating-outline">
                                    <textarea class="form-control @error('address') is-invalid @enderror" id="address" name="address" rows="2" placeholder="Address" style="height: 80px;">{{ old('address', $hostel->address) }}</textarea>
                                    <label for="address">Address</label>
                                    @error('address')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" class="form-control @error('city') is-invalid @enderror" id="city" name="city" value="{{ old('city', $hostel->city) }}" placeholder="City">
                                    <label for="city">City</label>
                                    @error('city')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" class="form-control @error('state') is-invalid @enderror" id="state" name="state" value="{{ old('state', $hostel->state) }}" placeholder="State">
                                    <label for="state">State</label>
                                    @error('state')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating form-floating-outline">
                                    <input type="text" class="form-control @error('pincode') is-invalid @enderror" id="pincode" name="pincode" value="{{ old('pincode', $hostel->pincode) }}" placeholder="Pincode" maxlength="10">
                                    <label for="pincode">Pincode</label>
                                    @error('pincode')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                        </div>

                        {{-- Deposit Settings --}}
                        <h6 class="mb-4 pt-4 border-top">Deposit Settings</h6>
                        <div class="row g-5 mb-6">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="number" class="form-control @error('default_deposit_amount') is-invalid @enderror" id="default_deposit_amount" name="default_deposit_amount" value="{{ old('default_deposit_amount', $hostel->default_deposit_amount ?? 3000) }}" min="0" step="0.01" required placeholder="Default Deposit Amount">
                                    <label for="default_deposit_amount">Default Deposit Amount (₹) <span class="text-danger">*</span></label>
                                    @error('default_deposit_amount')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                                <div class="form-text mt-2">
                                    <i class="ri-information-line me-1"></i>
                                    This deposit amount will be used throughout the system for new student registrations and deposit calculations.
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="alert alert-info mb-0">
                                    <h6 class="alert-heading mb-2">
                                        <i class="ri-lightbulb-line me-2"></i>About Deposit Amount
                                    </h6>
                                    <p class="mb-2 small">The default deposit amount is used when:</p>
                                    <ul class="mb-0 small ps-3">
                                        <li>Adding new student deposits</li>
                                        <li>Calculating balance & advance amounts</li>
                                        <li>Generating deposit receipts</li>
                                        <li>Creating financial reports</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        {{-- Social Media Links --}}
                        <h6 class="mb-4 pt-4 border-top">Social Media Links</h6>
                        <div class="row g-5 mb-6">
                            <div class="col-md-4">
                                <div class="form-floating form-floating-outline">
                                    <input type="url" class="form-control @error('facebook') is-invalid @enderror" id="facebook" name="facebook" value="{{ old('facebook', $hostel->facebook) }}" placeholder="Facebook URL">
                                    <label for="facebook"><i class="ri-facebook-fill me-2"></i>Facebook</label>
                                    @error('facebook')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating form-floating-outline">
                                    <input type="url" class="form-control @error('instagram') is-invalid @enderror" id="instagram" name="instagram" value="{{ old('instagram', $hostel->instagram) }}" placeholder="Instagram URL">
                                    <label for="instagram"><i class="ri-instagram-line me-2"></i>Instagram</label>
                                    @error('instagram')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating form-floating-outline">
                                    <input type="url" class="form-control @error('twitter') is-invalid @enderror" id="twitter" name="twitter" value="{{ old('twitter', $hostel->twitter) }}" placeholder="Twitter URL">
                                    <label for="twitter"><i class="ri-twitter-x-line me-2"></i>Twitter</label>
                                    @error('twitter')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                        </div>

                        <div class="mt-6">
                            <button type="submit" class="btn btn-primary me-3">
                                <i class="ri-save-line me-2"></i>Save Changes
                            </button>
                            <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('page-script')
<script>
(function() {
    var logoInput = document.getElementById('logoInput');
    var logoImg = document.getElementById('hostelLogoImg');
    var logoRemove = document.getElementById('logoRemove');
    var logoResetBtn = document.getElementById('logoResetBtn');

    // Logo preview on upload
    if (logoInput && logoImg) {
        logoInput.addEventListener('change', function() {
            if (this.files && this.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    logoImg.src = e.target.result;
                };
                reader.readAsDataURL(this.files[0]);
                if (logoRemove) logoRemove.value = '0';
            }
        });
    }

    // Reset logo to default
    if (logoResetBtn && logoRemove && logoImg) {
        logoResetBtn.addEventListener('click', function() {
            logoImg.src = @json(asset('assets/json/img/illustrations/misc-upgrade-account-illustration.png'));
            logoRemove.value = '1';
            if (logoInput) logoInput.value = '';
        });
    }
})();
</script>
@endsection
