@extends('layouts/contentNavbarLayout')

@section('title', 'Leave Management')

@section('vendor-style')
<style>
.leave-user-cell { display: flex; align-items: center; gap: 0.75rem; }
.leave-user-cell .avatar-wrap { flex-shrink: 0; width: 38px; height: 38px; border-radius: 50%; overflow: hidden; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 0.875rem; background: var(--bs-secondary-bg); }
.leave-user-cell .avatar-wrap img { width: 100%; height: 100%; object-fit: cover; }
.leave-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; }
.badge-pending { background-color: #ffc107; color: #000; }
.badge-approved { background-color: #198754; color: #fff; }
.badge-returned { background-color: #0d6efd; color: #fff; }
.badge-cancelled { background-color: #6c757d; color: #fff; }
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Leave Management</h4>
        <a href="{{ route('admin.leaves.create') }}" class="btn btn-primary"><i class="ri-add-line me-1"></i>Add Student Leave</a>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card mb-4">
        <div class="card-body">
            <form method="get" action="{{ route('admin.leaves.index') }}" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ $fromDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ $toDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select class="form-select" name="status">
                        <option value="all" {{ ($statusFilter ?? 'all') === 'all' ? 'selected' : '' }}>All</option>
                        <option value="pending" {{ ($statusFilter ?? '') === 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="approved" {{ ($statusFilter ?? '') === 'approved' ? 'selected' : '' }}>Approved</option>
                        <option value="returned" {{ ($statusFilter ?? '') === 'returned' ? 'selected' : '' }}>Returned</option>
                        <option value="cancelled" {{ ($statusFilter ?? '') === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Filter</button>
                    <a href="{{ route('admin.leaves.index') }}" class="btn btn-outline-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <ul class="nav nav-tabs mb-3" role="tablist">
        <li class="nav-item">
            <a href="{{ route('admin.leaves.index', array_merge(request()->only(['from_date', 'to_date']), ['status' => 'all'])) }}" class="nav-link {{ ($statusFilter ?? 'all') === 'all' ? 'active' : '' }}">All ({{ $leaves->count() }})</a>
        </li>
        <li class="nav-item">
            <a href="{{ route('admin.leaves.index', array_merge(request()->only(['from_date', 'to_date']), ['status' => 'pending'])) }}" class="nav-link {{ ($statusFilter ?? '') === 'pending' ? 'active' : '' }}">Pending ({{ $counts['pending'] ?? 0 }})</a>
        </li>
        <li class="nav-item">
            <a href="{{ route('admin.leaves.index', array_merge(request()->only(['from_date', 'to_date']), ['status' => 'approved'])) }}" class="nav-link {{ ($statusFilter ?? '') === 'approved' ? 'active' : '' }}">Approved ({{ $counts['approved'] ?? 0 }})</a>
        </li>
        <li class="nav-item">
            <a href="{{ route('admin.leaves.index', array_merge(request()->only(['from_date', 'to_date']), ['status' => 'returned'])) }}" class="nav-link {{ ($statusFilter ?? '') === 'returned' ? 'active' : '' }}">Returned ({{ $counts['returned'] ?? 0 }})</a>
        </li>
    </ul>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table leave-table table-hover">
                    <thead>
                        <tr>
                            <th>Student</th>
                            <th>Leave Period</th>
                            <th>Reason</th>
                            <th>Return Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($leaves as $leave)
                            @php $s = $leave->student; @endphp
                            <tr>
                                <td>
                                    <div class="leave-user-cell">
                                        <div class="avatar-wrap">
                                            @if($s->documents->where('document_type', 'profile_photo')->first())
                                                <img src="{{ asset('storage/' . $s->documents->where('document_type', 'profile_photo')->first()->file_path) }}" alt="">
                                            @else
                                                {{ strtoupper(mb_substr($s->first_name ?? '', 0, 1)) }}
                                            @endif
                                        </div>
                                        <div>
                                            <span class="fw-medium">{{ $s->full_name }}</span>
                                            <span class="d-block small text-muted">{{ $s->student_mobile ?? '—' }}</span>
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $leave->from_date->format('d/m/Y') }} – {{ $leave->to_date->format('d/m/Y') }}</td>
                                <td><span class="text-truncate d-inline-block" style="max-width: 220px;" title="{{ $leave->reason }}">{{ $leave->reason }}</span></td>
                                <td>{{ $leave->return_date?->format('d/m/Y') ?? '—' }}</td>
                                <td>
                                    @if($leave->status === \App\Models\Leave::STATUS_PENDING)
                                        <span class="badge badge-pending">Pending</span>
                                    @elseif($leave->status === \App\Models\Leave::STATUS_CANCELLED)
                                        <span class="badge badge-cancelled">Cancelled</span>
                                    @elseif($leave->return_date)
                                        <span class="badge badge-returned">Returned</span>
                                    @else
                                        <span class="badge badge-approved">Approved</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="d-flex gap-1 flex-wrap">
                                        @if($leave->status === \App\Models\Leave::STATUS_PENDING)
                                            <form action="{{ route('admin.leaves.approve', $leave) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-success" title="Leave Approve"><i class="ri-check-line me-1"></i>Approve</button>
                                            </form>
                                            <a href="https://wa.me/91{{ preg_replace('/\D/', '', $s->student_mobile ?? '') }}?text={{ urlencode('Your leave from ' . $leave->from_date->format('d/m/Y') . ' to ' . $leave->to_date->format('d/m/Y') . ' has been approved.') }}" target="_blank" rel="noopener" class="btn btn-sm btn-outline-success" title="WhatsApp approval"><i class="ri-whatsapp-line"></i></a>
                                            <form action="{{ route('admin.leaves.cancel', $leave) }}" method="POST" class="d-inline" onsubmit="return confirm('Cancel this leave request?');">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-danger" title="Cancel"><i class="ri-close-line me-1"></i>Cancel</button>
                                            </form>
                                        @elseif($leave->status === \App\Models\Leave::STATUS_APPROVED && !$leave->return_date)
                                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#returnModal{{ $leave->id }}" title="Record Return"><i class="ri-arrow-left-right-line me-1"></i>Return</button>
                                            @include('admin.leaves._return_modal', ['leave' => $leave])
                                        @else
                                            <span class="text-muted small">—</span>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="6" class="text-center text-muted py-4">No leave records match the selected filter.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
