@extends('layouts/contentNavbarLayout')

@section('title', 'Edit Bed')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">Edit Bed</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.beds.update', $bed) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="mb-4">
                    <label for="room_id" class="form-label">Room <span class="text-danger">*</span></label>
                    <select class="form-select @error('room_id') is-invalid @enderror" id="room_id" name="room_id" required>
                        @foreach ($floors as $floor)
                            <optgroup label="{{ $floor->name }}">
                                @foreach ($floor->rooms as $room)
                                    <option value="{{ $room->id }}" {{ old('room_id', $bed->room_id) == $room->id ? 'selected' : '' }}>{{ $room->name }}</option>
                                @endforeach
                            </optgroup>
                        @endforeach
                    </select>
                    @error('room_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="name" class="form-label">Bed name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $bed->name) }}" required />
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="rent_amount" class="form-label">Rent Amount (₹) <span class="text-danger">*</span></label>
                    <input type="number" class="form-control @error('rent_amount') is-invalid @enderror" id="rent_amount" name="rent_amount" value="{{ old('rent_amount', $bed->rent_amount) }}" min="0" step="0.01" required />
                    @error('rent_amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                    <select class="form-select @error('status') is-invalid @enderror" id="status" name="status" required>
                        <option value="available" {{ old('status', $bed->status) === 'available' ? 'selected' : '' }}>Available</option>
                        <option value="occupied" {{ old('status', $bed->status) === 'occupied' ? 'selected' : '' }}>Occupied</option>
                    </select>
                    @error('status')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary">Update bed</button>
                <a href="{{ route('admin.beds.show', $bed) }}" class="btn btn-outline-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection
