@extends('layouts/contentNavbarLayout')

@section('title', 'Add Room')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">Add Room</h4>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if($floors->isEmpty())
        <div class="alert alert-warning">
            No floors found. Please <a href="{{ route('admin.floors.create') }}">create a floor</a> first.
        </div>
    @else
    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.rooms.store') }}" method="POST">
                @csrf
                <div class="mb-4">
                    <label for="floor_id" class="form-label">Floor <span class="text-danger">*</span></label>
                    <select class="form-select @error('floor_id') is-invalid @enderror" id="floor_id" name="floor_id" required>
                        <option value="">Select floor</option>
                        @foreach ($floors as $floor)
                            <option value="{{ $floor->id }}" {{ old('floor_id') == $floor->id ? 'selected' : '' }}>{{ $floor->name }}</option>
                        @endforeach
                    </select>
                    @error('floor_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="name" class="form-label">Room name / number <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" placeholder="e.g. 101, Room A" required />
                    <div class="form-text">Must be unique within the selected floor.</div>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="capacity" class="form-label">Room capacity (max beds)</label>
                    <input type="number" class="form-control @error('capacity') is-invalid @enderror" id="capacity" name="capacity" value="{{ old('capacity', 0) }}" min="0" />
                    <div class="form-text">Maximum number of beds allowed in this room. Set 0 for no limit.</div>
                    @error('capacity')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <hr class="my-4" />
                <h6 class="mb-3">Add beds to this room (optional)</h6>
                <div class="mb-4">
                    <div class="d-flex gap-3 flex-wrap">
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="add_beds" id="add_beds_none" value="" {{ old('add_beds') === '' || old('add_beds') === null ? 'checked' : '' }} />
                            <label class="form-check-label" for="add_beds_none">None</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="add_beds" id="add_beds_single" value="single" {{ old('add_beds') === 'single' ? 'checked' : '' }} />
                            <label class="form-check-label" for="add_beds_single">Single bed</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="add_beds" id="add_beds_bulk" value="bulk" {{ old('add_beds') === 'bulk' ? 'checked' : '' }} />
                            <label class="form-check-label" for="add_beds_bulk">Bulk beds</label>
                        </div>
                    </div>
                </div>

                <div id="room-bed-single" class="mb-4" style="display: none;">
                    <label for="bed_name" class="form-label">Bed name</label>
                    <input type="text" class="form-control @error('bed_name') is-invalid @enderror" id="bed_name" name="bed_name" value="{{ old('bed_name') }}" placeholder="e.g. Bed 1" />
                    @error('bed_name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div id="room-bed-bulk" class="mb-4" style="display: none;">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="bed_prefix" class="form-label">Name prefix</label>
                            <input type="text" class="form-control" id="bed_prefix" name="bed_prefix" value="{{ old('bed_prefix', 'Bed') }}" placeholder="e.g. Bed" />
                            <div class="form-text">Beds: prefix + number (e.g. Bed 1, Bed 2).</div>
                        </div>
                        <div class="col-md-4">
                            <label for="bed_count" class="form-label">Number of beds</label>
                            <input type="number" class="form-control @error('bed_count') is-invalid @enderror" id="bed_count" name="bed_count" value="{{ old('bed_count', 1) }}" min="1" max="50" />
                            @error('bed_count')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary">Create room</button>
                <a href="{{ route('admin.rooms.index') }}" class="btn btn-outline-secondary">Cancel</a>
            </form>
        </div>
    </div>
    @endif
</div>
@endsection

@section('page-script')
<script>
(function() {
    var addBedsNone = document.getElementById('add_beds_none');
    var addBedsSingle = document.getElementById('add_beds_single');
    var addBedsBulk = document.getElementById('add_beds_bulk');
    var singleBlock = document.getElementById('room-bed-single');
    var bulkBlock = document.getElementById('room-bed-bulk');
    var bedName = document.getElementById('bed_name');
    var bedCount = document.getElementById('bed_count');

    function toggle() {
        singleBlock.style.display = 'none';
        bulkBlock.style.display = 'none';
        if (bedName) bedName.removeAttribute('required');
        if (bedCount) bedCount.removeAttribute('required');
        if (addBedsSingle && addBedsSingle.checked) {
            singleBlock.style.display = 'block';
            if (bedName) bedName.setAttribute('required', 'required');
        } else if (addBedsBulk && addBedsBulk.checked) {
            bulkBlock.style.display = 'block';
            if (bedCount) bedCount.setAttribute('required', 'required');
        }
    }

    if (addBedsNone) addBedsNone.addEventListener('change', toggle);
    if (addBedsSingle) addBedsSingle.addEventListener('change', toggle);
    if (addBedsBulk) addBedsBulk.addEventListener('change', toggle);
    toggle();
})();
</script>
@endsection
