@extends('layouts/contentNavbarLayout')

@section('title', 'Rooms')

@section('vendor-style')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" />
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Rooms</h4>
        <a href="{{ route('admin.rooms.create') }}" class="btn btn-primary">Add Room</a>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="roomsTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Room</th>
                            <th>Floor</th>
                            <th>Beds / Capacity</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($rooms as $room)
                            <tr>
                                <td>{{ $room->id }}</td>
                                <td>{{ $room->name }}</td>
                                <td>{{ $room->floor->name }}</td>
                                <td>{{ $room->beds_count }}{{ $room->capacity > 0 ? ' / ' . $room->capacity : '' }}</td>
                                <td class="text-end">
                                    <a href="{{ route('admin.rooms.show', $room) }}" class="btn btn-sm btn-outline-primary me-1" title="View">View</a>
                                    <a href="{{ route('admin.rooms.edit', $room) }}" class="btn btn-sm btn-outline-secondary me-1" title="Edit">Edit</a>
                                    <form action="{{ route('admin.rooms.destroy', $room) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this room? All beds in it will be removed.');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger" title="Delete">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted">No rooms yet. <a href="{{ route('admin.rooms.create') }}">Add a room</a> (create a <a href="{{ route('admin.floors.create') }}">floor</a> first if needed).</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('vendor-script')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
@endsection

@section('page-script')
<script>
$(function() {
    var table = $('#roomsTable');
    if (table.find('tbody tr').length > 0 && !table.find('tbody tr td').first().attr('colspan')) {
        table.DataTable({
            order: [[1, 'asc']],
            pageLength: 10,
            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, 'All']],
            language: { search: '', searchPlaceholder: 'Search...' },
            columnDefs: [{ orderable: false, targets: -1 }]
        });
    }
});
</script>
@endsection
