@extends('layouts/contentNavbarLayout')

@section('title', 'Room: ' . $room->name)

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Room: {{ $room->name }}</h4>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.rooms.edit', $room) }}" class="btn btn-outline-primary">Edit</a>
            <form action="{{ route('admin.rooms.destroy', $room) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this room? All beds in it will be removed.');">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-outline-danger">Delete</button>
            </form>
            <a href="{{ route('admin.rooms.index') }}" class="btn btn-outline-secondary">Back to list</a>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <dl class="row mb-0">
                <dt class="col-sm-3">Room</dt>
                <dd class="col-sm-9">{{ $room->name }}</dd>
                <dt class="col-sm-3">Floor</dt>
                <dd class="col-sm-9"><a href="{{ route('admin.floors.show', $room->floor) }}">{{ $room->floor->name }}</a></dd>
                <dt class="col-sm-3">Capacity (max beds)</dt>
                <dd class="col-sm-9">{{ $room->capacity ?: 'No limit' }}</dd>
                <dt class="col-sm-3">Beds</dt>
                <dd class="col-sm-9">{{ $room->beds->count() }}</dd>
            </dl>
        </div>
    </div>

    @if($room->beds->isNotEmpty())
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Beds in this room</h5>
        </div>
        <div class="card-body">
            <ul class="list-group list-group-flush">
                @foreach($room->beds as $bed)
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <a href="{{ route('admin.beds.show', $bed) }}">{{ $bed->name }}</a>
                        @if($bed->status === \App\Models\Bed::STATUS_AVAILABLE)
                            <span class="badge bg-success">Available</span>
                        @else
                            <span class="badge bg-secondary">Occupied</span>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
    @endif
</div>
@endsection
