<li class="list-group-item notification-list-item {{ $notification->is_read ? '' : 'unread-item' }}" 
    data-notification-id="{{ $notification->id }}"
    style="position: relative;">
    
    <!-- Priority Indicator -->
    <div class="priority-indicator {{ $notification->priority }}"></div>
    
    <div class="d-flex align-items-start p-3 ps-4">
        <!-- Icon -->
        <div class="flex-shrink-0 me-3">
            <div class="avatar avatar-md">
                <span class="avatar-initial rounded-circle 
                    {{ match($notification->priority) {
                        'critical' => 'bg-label-danger',
                        'warning' => 'bg-label-warning',
                        'info' => 'bg-label-info',
                        'success' => 'bg-label-success',
                        default => 'bg-label-secondary'
                    } }}">
                    @switch($notification->type)
                        @case('agreement_expiring')
                            <i class="ri-file-text-line ri-24px"></i>
                            @break
                        @case('rent_due')
                            <i class="ri-calendar-line ri-24px"></i>
                            @break
                        @case('rent_overdue')
                            <i class="ri-alert-line ri-24px"></i>
                            @break
                        @case('deposit_low')
                            <i class="ri-money-dollar-circle-line ri-24px"></i>
                            @break
                        @case('student_pending')
                            <i class="ri-user-add-line ri-24px"></i>
                            @break
                        @default
                            <i class="ri-notification-line ri-24px"></i>
                    @endswitch
                </span>
            </div>
        </div>

        <!-- Content -->
        <div class="flex-grow-1">
            <div class="d-flex justify-content-between align-items-start mb-1">
                <h6 class="mb-0 fw-semibold">{{ $notification->title }}</h6>
                @if(!$notification->is_read)
                    <span class="unread-indicator ms-2"></span>
                @endif
            </div>
            
            <p class="mb-2 text-body">{{ $notification->message }}</p>
            
            <!-- Meta Information -->
            <div class="d-flex align-items-center gap-3 text-muted small">
                @if(isset($notification->meta['room_bed']))
                    <span><i class="ri-door-line me-1"></i>{{ $notification->meta['room_bed'] }}</span>
                @endif
                
                @if(isset($notification->meta['days_remaining']))
                    <span><i class="ri-time-line me-1"></i>{{ $notification->meta['days_remaining'] }} days left</span>
                @endif
                
                @if(isset($notification->meta['days_overdue']))
                    <span class="text-danger"><i class="ri-alarm-warning-line me-1"></i>{{ $notification->meta['days_overdue'] }} days overdue</span>
                @endif
                
                @if(isset($notification->meta['amount']))
                    <span><i class="ri-money-rupee-circle-line me-1"></i>₹{{ number_format($notification->meta['amount'], 2) }}</span>
                @endif
                
                <span class="ms-auto">{{ $notification->time_ago }}</span>
            </div>
        </div>

        <!-- Actions -->
        <div class="flex-shrink-0 ms-3">
            <div class="dropdown">
                <button class="btn btn-sm btn-icon btn-text-secondary rounded-pill dropdown-toggle hide-arrow" 
                        data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="ri-more-2-line ri-20px"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <a class="dropdown-item" href="{{ $notification->action_url }}" 
                           onclick="markAsRead({{ $notification->id }})">
                            <i class="ri-eye-line me-2"></i>View Details
                        </a>
                    </li>
                    @if(!$notification->is_read)
                    <li>
                        <a class="dropdown-item" href="javascript:void(0)" 
                           onclick="markAsRead({{ $notification->id }})">
                            <i class="ri-check-line me-2"></i>Mark as Read
                        </a>
                    </li>
                    @endif
                </ul>
            </div>
        </div>
    </div>
</li>
