@extends('layouts/blankLayout')

@section('title', 'Police Verification Form - ' . $student->full_name)

@section('page-style')
<style>
@media print { body { -webkit-print-color-adjust: exact; print-color-adjust: exact; } .no-print { display: none !important; } }
.police-form { max-width: 720px; margin: 0 auto; font-family: system-ui, sans-serif; }
.police-header { border-bottom: 1px solid #333; padding-bottom: 1rem; margin-bottom: 1.5rem; }
.police-title { font-size: 1.25rem; font-weight: 700; }
.police-address { font-size: 0.9rem; color: #555; margin-top: 0.25rem; }
.police-declaration { font-size: 1rem; text-align: justify; margin: 1.5rem 0; line-height: 1.6; }
.police-field-list { list-style: none; padding-left: 0; font-size: 1rem; }
.police-field-list li { margin-bottom: 0.5rem; }
.police-signature { margin-top: 2rem; }
.police-signature img { max-width: 200px; max-height: 45px; object-fit: contain; }
</style>
@endsection

@section('content')
<div class="police-form p-4">
    <div class="no-print mb-3">
        <button type="button" class="btn btn-primary btn-sm" onclick="window.print();"><i class="ri-printer-line me-1"></i>Print</button>
        <a href="{{ route('admin.police-records.index') }}" class="btn btn-outline-secondary btn-sm ms-2">Back to Police Records</a>
    </div>

    <div class="police-header row">
        <div class="col-3">
            @php $photo = $student->documents->where('document_type', 'profile_photo')->first(); @endphp
            @if($photo)
                <img src="{{ asset('storage/' . $photo->file_path) }}" alt="" style="width:100px;height:125px;object-fit:cover;">
            @endif
        </div>
        <div class="col-9">
            <div class="police-title">श्री गुरुदेव बॉईज हॉस्टेल</div>
            <div class="police-address">प्लॉट नं. १८, महावीर नगर, भाजीवालीबाई पुतळा जवळ, पिर बाजार, ऊस्मानपुरा औरंगाबाद (महाराष्ट्र) (पिन नंबर: ४३१००५).</div>
        </div>
    </div>

    <div class="text-center mb-3">
        <h4>Police Verification Form</h4>
    </div>

    <div class="police-declaration">
        <p>मी <strong>{{ $student->full_name }}</strong> श्री गुरुदेव बॉईज हॉस्टेल मध्ये रुम नंबर <strong>{{ $student->room_bed_identifier ?? ($student->bed?->name ?? '—') }}</strong> मधला विद्यार्थी असून, माझे आधार नंबर <strong>{{ $student->aadhar_number ?? '—' }}</strong> आहे, आणि मी दिनांक <strong>{{ $admissionDate?->format('d/m/Y') ?? '—' }}</strong> पासून <strong>{{ $leavingDate?->format('d/m/Y') ?? '—' }}</strong> पर्यंत हॉस्टेल मध्ये राहणार आहे. तरी मला हॉस्टेल चे नियम आणि अटी मान्य आहे, आणि माझ्याकडून काही चुकीचे घडल्यास मी जबाबदार राहणार.</p>
    </div>

    <ul class="police-field-list">
        <li><strong>कायमचा पत्ता:</strong> {{ collect([$student->permanent_locality, $student->permanent_taluka, $student->permanent_district, $student->permanent_state])->filter()->implode(', ') ?: '—' }}</li>
        <li><strong>मो. नं.:</strong> {{ $student->student_mobile ?? '—' }}</li>
        <li><strong>पालकाचा मो. नं.:</strong> {{ $student->parent_mobile ?? '—' }}</li>
        <li><strong>दिनांक:</strong></li>
        <li><strong>ठिकाण:</strong></li>
    </ul>

    <div class="police-signature text-end">
        <label class="d-block small fw-medium">विद्यार्थ्याची स्वाक्षरी</label>
        @php $ssign = $student->documents->where('document_type', 'student_signature')->first(); @endphp
        @if($ssign)
            <img src="{{ asset('storage/' . $ssign->file_path) }}" alt="">
        @else
            <span class="text-muted">—</span>
        @endif
    </div>
</div>
@endsection
