@extends('layouts/contentNavbarLayout')

@section('title', 'Police Record Details')

@section('vendor-style')
<style>
.police-user-cell { display: flex; align-items: center; gap: 0.75rem; }
.police-user-cell .avatar-wrap { flex-shrink: 0; width: 38px; height: 38px; border-radius: 50%; overflow: hidden; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 0.875rem; background: var(--bs-secondary-bg); }
.police-user-cell .avatar-wrap img { width: 100%; height: 100%; object-fit: cover; }
.police-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; }
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Police Record Details</h4>
    </div>

    <p class="text-muted mb-4">Submit verification details of residents to the nearest police station. Use <strong>View Form</strong> to open the Marathi declaration for printing.</p>

    <ul class="nav nav-tabs mb-3" role="tablist">
        <li class="nav-item">
            <button type="button" class="nav-link active" data-bs-toggle="tab" data-bs-target="#police-active" role="tab">Active ({{ $active->count() }})</button>
        </li>
        <li class="nav-item">
            <button type="button" class="nav-link" data-bs-toggle="tab" data-bs-target="#police-released" role="tab">Released ({{ $released->count() }})</button>
        </li>
    </ul>

    <div class="tab-content">
        <div class="tab-pane fade show active" id="police-active" role="tabpanel">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table police-table table-hover">
                            <thead>
                                <tr>
                                    <th>Student</th>
                                    <th>Room / Bed</th>
                                    <th>Aadhar No.</th>
                                    <th>Admission</th>
                                    <th>Leaving Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($active as $s)
                                    @php
                                        $firstAg = $s->agreementHistories->sortBy('from_date')->first();
                                        $latestAg = $s->agreementHistories->sortByDesc('to_date')->first();
                                    @endphp
                                    <tr>
                                        <td>
                                            <div class="police-user-cell">
                                                <div class="avatar-wrap">
                                                    @if($s->documents->where('document_type', 'profile_photo')->first())
                                                        <img src="{{ asset('storage/' . $s->documents->where('document_type', 'profile_photo')->first()->file_path) }}" alt="">
                                                    @else
                                                        {{ strtoupper(mb_substr($s->first_name ?? '', 0, 1)) }}
                                                    @endif
                                                </div>
                                                <div>
                                                    <span class="fw-medium">{{ $s->full_name }}</span>
                                                    <span class="d-block small text-muted">{{ $s->student_mobile ?? '—' }} / {{ $s->parent_mobile ?? '—' }}</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $s->room_bed_identifier ?? '—' }}</td>
                                        <td>{{ $s->aadhar_number ?? '—' }}</td>
                                        <td>{{ $firstAg?->from_date?->format('d/m/Y') ?? '—' }}</td>
                                        <td>{{ $latestAg?->to_date?->format('d/m/Y') ?? '—' }}</td>
                                        <td>
                                            <a href="{{ route('admin.police-records.form', $s) }}" target="_blank" class="btn btn-sm btn-outline-primary" title="View Form (Marathi)"><i class="ri-file-text-line me-1"></i>View Form</a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="6" class="text-center text-muted py-4">No active students.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="police-released" role="tabpanel">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table police-table table-hover">
                            <thead>
                                <tr>
                                    <th>Student</th>
                                    <th>Room / Bed</th>
                                    <th>Aadhar No.</th>
                                    <th>Leaving Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($released as $s)
                                    @php $latestAg = $s->agreementHistories->sortByDesc('to_date')->first(); @endphp
                                    <tr>
                                        <td>
                                            <div class="police-user-cell">
                                                <div class="avatar-wrap">{{ strtoupper(mb_substr($s->first_name ?? '', 0, 1)) }}</div>
                                                <div>
                                                    <span class="fw-medium">{{ $s->full_name }}</span>
                                                    <span class="d-block small text-muted">{{ $s->student_mobile ?? '—' }}</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $s->room_bed_identifier ?? '—' }}</td>
                                        <td>{{ $s->aadhar_number ?? '—' }}</td>
                                        <td>{{ $latestAg?->to_date?->format('d/m/Y') ?? '—' }}</td>
                                        <td>
                                            <a href="{{ route('admin.police-records.form', $s) }}" target="_blank" class="btn btn-sm btn-outline-secondary" title="View Form"><i class="ri-file-text-line me-1"></i>View Form</a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="5" class="text-center text-muted py-4">No released students.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
