@extends('layouts/blankLayout')

@section('title', 'Rent Receipt - ' . ($rent->receipt_no ?? 'R' . $rent->id))

@section('page-style')
<style>
@media print {
    body { -webkit-print-color-adjust: exact; print-color-adjust: exact; }
    .no-print { display: none !important; }
}
.receipt { max-width: 640px; margin: 0 auto; font-family: system-ui, sans-serif; }
.receipt-header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 1rem; margin-bottom: 1.5rem; }
.receipt-title { font-size: 1.5rem; font-weight: 700; text-transform: uppercase; letter-spacing: 0.05em; }
.receipt-meta { font-size: 0.875rem; color: #555; margin-top: 0.5rem; }
.receipt-table { width: 100%; border-collapse: collapse; margin: 1rem 0; }
.receipt-table th, .receipt-table td { padding: 0.5rem 0.75rem; text-align: left; border-bottom: 1px solid #dee2e6; }
.receipt-table th { font-weight: 600; width: 40%; color: #495057; }
.amount-words { font-style: italic; margin-top: 0.5rem; padding: 0.5rem; background: #f8f9fa; border-radius: 0.25rem; }
.receipt-footer { margin-top: 2rem; text-align: center; font-size: 0.8125rem; color: #6c757d; }
</style>
@endsection

@section('content')
<div class="receipt p-4">
    @if(empty($shareMode))
    <div class="no-print mb-3 d-flex align-items-center gap-2 flex-wrap">
        <button type="button" class="btn btn-primary btn-sm" onclick="window.print();"><i class="ri-printer-line me-1"></i>Print</button>
        <a href="{{ route('admin.rents.index') }}" class="btn btn-outline-secondary btn-sm">Back to Rent Management</a>
        @isset($pdfDownloadUrl)
            <x-share-buttons :pdf-download-url="$pdfDownloadUrl" :email-type="$emailType ?? 'rent'" :email-id="$emailId ?? $rent->id" />
        @endisset
    </div>
    @else
    <div class="no-print mb-3">
        <button type="button" class="btn btn-primary btn-sm" onclick="window.print();"><i class="ri-printer-line me-1"></i>Print</button>
    </div>
    @endif

    <div class="receipt-header">
        <div class="receipt-title">{{ config('app.name', 'Hostel') }}</div>
        <div class="receipt-meta">Rent Receipt</div>
    </div>

    <table class="receipt-table">
        <tr>
            <th>Receipt No.</th>
            <td>{{ $rent->receipt_no ?? 'R' . $rent->id }}</td>
        </tr>
        <tr>
            <th>Date</th>
            <td>{{ $rent->paid_at ? $rent->paid_at->format('d/m/Y') : '—' }}</td>
        </tr>
        <tr>
            <th>Student ID</th>
            <td>{{ $rent->student_id }}</td>
        </tr>
        <tr>
            <th>Student Name</th>
            <td>{{ $rent->student->full_name ?? '—' }}</td>
        </tr>
        @if($rent->student && ($rent->student->room_bed_identifier || $rent->student->bed))
            <tr>
                <th>Room / Bed</th>
                <td>{{ $rent->student->room_bed_identifier ?? ($rent->student->bed ? $rent->student->bed->name ?? '—' : '—') }}</td>
            </tr>
        @endif
        <tr>
            <th>Period</th>
            <td>{{ $rent->period_from->format('d/m/Y') }} to {{ $rent->period_to->format('d/m/Y') }}</td>
        </tr>
        <tr>
            <th>Amount (₹)</th>
            <td>{{ number_format($rent->amount, 2) }}</td>
        </tr>
        <tr>
            <th>Amount in Words</th>
            <td>
                <div class="amount-words">{{ $amountInWords ?? '—' }}</div>
            </td>
        </tr>
        <tr>
            <th>Payment Mode</th>
            <td>{{ \Illuminate\Support\Arr::get(config('student_registration.payment_modes', []), $rent->payment_mode, $rent->payment_mode) }}</td>
        </tr>
        @if($rent->transaction_id)
            <tr>
                <th>UTR / Transaction ID</th>
                <td>{{ $rent->transaction_id }}</td>
            </tr>
        @endif
        @if($rent->cheque_number)
            <tr>
                <th>Cheque Number</th>
                <td>{{ $rent->cheque_number }}</td>
            </tr>
        @endif
    </table>

    <div class="receipt-footer">
        This is a computer-generated receipt. Thank you for your payment.
    </div>
</div>
@endsection
