@extends('layouts/contentNavbarLayout')

@section('title', 'Edit Student')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">Edit Student Details</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.students.update', $student) }}" method="POST">
                @csrf
                @method('PATCH')
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">First Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="first_name" value="{{ old('first_name', $student->first_name) }}" required />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Middle Name</label>
                        <input type="text" class="form-control" name="middle_name" value="{{ old('middle_name', $student->middle_name) }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Last Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="last_name" value="{{ old('last_name', $student->last_name) }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" name="email" value="{{ old('email', $student->email) }}" />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Student Mobile</label>
                        <input type="text" class="form-control" name="student_mobile" value="{{ old('student_mobile', $student->student_mobile) }}" />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Parent Mobile</label>
                        <input type="text" class="form-control" name="parent_mobile" value="{{ old('parent_mobile', $student->parent_mobile) }}" />
                    </div>
                    <div class="col-12">
                        <label class="form-label">Permanent Locality</label>
                        <input type="text" class="form-control" name="permanent_locality" value="{{ old('permanent_locality', $student->permanent_locality) }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">District</label>
                        <input type="text" class="form-control" name="permanent_district" value="{{ old('permanent_district', $student->permanent_district) }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">State</label>
                        <input type="text" class="form-control" name="permanent_state" value="{{ old('permanent_state', $student->permanent_state) }}" />
                    </div>
                </div>
                <hr class="my-4" />
                <button type="submit" class="btn btn-primary">Update</button>
                <a href="{{ route('admin.students.show', $student) }}" class="btn btn-outline-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection
