@php
$steps = [
    1 => ['label' => 'Personal & Academic', 'route' => null],
    2 => ['label' => 'Documents', 'route' => 'admin.students.registration.step2'],
    3 => ['label' => 'Bed Allotment', 'route' => 'admin.students.registration.step3'],
    4 => ['label' => 'Security Deposit', 'route' => 'admin.students.registration.step4'],
    5 => ['label' => 'Payment & Activate', 'route' => 'admin.students.registration.step5'],
];
$current = $currentStep ?? 1;
@endphp
<nav class="mb-4" aria-label="Registration steps">
    <ol class="breadcrumb mb-0 flex-wrap">
        @foreach($steps as $num => $step)
            <li class="breadcrumb-item {{ $num == $current ? 'active' : '' }}">
                @if($num < $current && isset($student) && $step['route'])
                    <a href="{{ route($step['route'], $student) }}">Step {{ $num }}: {{ $step['label'] }}</a>
                @else
                    <span>Step {{ $num }}: {{ $step['label'] }}</span>
                @endif
            </li>
        @endforeach
    </ol>
</nav>
