@extends('layouts/contentNavbarLayout')

@section('title', 'Student Registration – Step 2')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    @include('admin.students.registration._steps_nav', ['currentStep' => 2, 'student' => $student])

    <h4 class="fw-bold py-3 mb-4">Step 2: Document Upload</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <p class="text-muted small mb-4">Allowed: JPG, JPEG, PNG, PDF. Max {{ number_format($uploadConfig['max_size'] ?? 5120 / 1024, 1) }} MB per file.</p>
            <form action="{{ route('admin.students.registration.storeStep2', $student) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row g-3">
                    @foreach($documentTypes as $key => $label)
                        <div class="col-md-6">
                            <label class="form-label">{{ $label }} <span class="text-danger">*</span></label>
                            <input type="file" class="form-control" name="{{ $key }}" accept=".jpg,.jpeg,.png,.pdf" required />
                        </div>
                    @endforeach
                </div>
                <hr class="my-4" />
                <button type="submit" class="btn btn-primary">Upload & Continue to Step 3</button>
                <a href="{{ route('admin.students.registration.step3', $student) }}" class="btn btn-outline-secondary">Skip (upload later)</a>
            </form>
        </div>
    </div>
</div>
@endsection
