@extends('layouts/contentNavbarLayout')

@section('title', 'Student Registration – Step 4')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    @include('admin.students.registration._steps_nav', ['currentStep' => 4, 'student' => $student])

    <h4 class="fw-bold py-3 mb-4">Step 4: Security Deposit</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <p class="text-muted small mb-4">Record the security deposit period and payment details. Agreement period will be set from the deposit dates.</p>
            <form action="{{ route('admin.students.registration.storeStep4', $student) }}" method="POST">
                @csrf
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Deposit Period – From Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" name="from_date" value="{{ old('from_date') }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Deposit Period – To Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" name="to_date" value="{{ old('to_date') }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Actual Deposit Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" name="actual_deposit_date" value="{{ old('actual_deposit_date') }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Amount (₹) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="amount" step="0.01" min="0" value="{{ old('amount') }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Payment Mode <span class="text-danger">*</span></label>
                        <select name="payment_mode" class="form-select" required>
                            <option value="">— Select —</option>
                            @foreach($paymentModes as $key => $label)
                                <option value="{{ $key }}" {{ old('payment_mode') === $key ? 'selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Transaction ID / UTR Number</label>
                        <input type="text" class="form-control" name="transaction_id" value="{{ old('transaction_id') }}" placeholder="Optional" />
                    </div>
                </div>
                <hr class="my-4" />
                <button type="submit" class="btn btn-primary">Save Deposit & Continue to Step 5</button>
                <a href="{{ route('admin.students.index') }}" class="btn btn-outline-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection
