@extends('layouts/contentNavbarLayout')

@section('title', 'Features - Website')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0">Features/Services Management</h4>
        <div class="d-flex gap-2">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addFeatureModal">
                <i class="ri-add-line me-1"></i>Add Feature
            </button>
            <a href="{{ route('home') }}" class="btn btn-outline-primary" target="_blank">
                <i class="ri-eye-line me-1"></i>Preview Site
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th width="80">Icon</th>
                            <th>Title</th>
                            <th>Description</th>
                            <th width="100">Order</th>
                            <th width="100">Status</th>
                            <th width="150">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($features as $feature)
                        <tr>
                            <td class="text-center">
                                <i class="{{ $feature->icon }}" style="font-size: 1.5rem; color: #696cff;"></i>
                            </td>
                            <td>{{ $feature->title }}</td>
                            <td>{{ Str::limit($feature->description, 80) }}</td>
                            <td>{{ $feature->sort_order }}</td>
                            <td>
                                @if($feature->is_active)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <button type="button" class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#editFeatureModal{{ $feature->id }}">
                                    <i class="ri-edit-line"></i> Edit
                                </button>
                                <form action="{{ route('admin.website.features.delete', $feature) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this feature?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>

                        <!-- Edit Feature Modal -->
                        <div class="modal fade" id="editFeatureModal{{ $feature->id }}" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="{{ route('admin.website.features.update', $feature) }}" method="POST">
                                        @csrf
                                        @method('PUT')
                                        <div class="modal-header">
                                            <h5 class="modal-title">Edit Feature</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label class="form-label">Icon Class <span class="text-danger">*</span></label>
                                                <input type="text" class="form-control" name="icon" value="{{ $feature->icon }}" required placeholder="ri-shield-check-line">
                                                <div class="form-text">
                                                    Use Remix Icons: <a href="https://remixicon.com/" target="_blank">Browse Icons</a>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Title <span class="text-danger">*</span></label>
                                                <input type="text" class="form-control" name="title" value="{{ $feature->title }}" required>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Description <span class="text-danger">*</span></label>
                                                <textarea class="form-control" name="description" rows="3" required>{{ $feature->description }}</textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Sort Order</label>
                                                <input type="number" class="form-control" name="sort_order" value="{{ $feature->sort_order }}" min="0">
                                            </div>
                                            <div class="mb-3">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" name="is_active" id="is_active{{ $feature->id }}" {{ $feature->is_active ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="is_active{{ $feature->id }}">Active</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                                            <button type="submit" class="btn btn-primary">Update Feature</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">No features yet. Add your first feature!</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Add Feature Modal -->
<div class="modal fade" id="addFeatureModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.website.features.store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Add New Feature</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Icon Class <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('icon') is-invalid @enderror" name="icon" value="{{ old('icon') }}" required placeholder="ri-shield-check-line">
                        @error('icon')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">
                            Use Remix Icons: <a href="https://remixicon.com/" target="_blank">Browse Icons</a>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('title') is-invalid @enderror" name="title" value="{{ old('title') }}" required placeholder="24/7 Security">
                        @error('title')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('description') is-invalid @enderror" name="description" rows="3" required placeholder="Brief description of the feature...">{{ old('description') }}</textarea>
                        @error('description')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Sort Order</label>
                        <input type="number" class="form-control" name="sort_order" value="{{ old('sort_order') }}" min="0" placeholder="Auto-assigned if empty">
                        <div class="form-text">Lower numbers appear first</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Feature</button>
                </div>
            </form>
        </div>
    </div>
</div>

@if($errors->any())
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var modal = new bootstrap.Modal(document.getElementById('addFeatureModal'));
        modal.show();
    });
</script>
@endif
@endsection
