@extends('layouts/blankLayout')

@section('title', 'Verify OTP')

@section('page-style')
@vite(['resources/assets/vendor/scss/pages/page-auth.scss'])
<style>
.auth-otp-input {
    width: 48px;
    height: 48px;
    text-align: center;
    font-size: 1.25rem;
    font-weight: 600;
}
.otp-sent-banner {
    background-color: #e7f3ff;
    border: 1px solid #b3d9ff;
    border-radius: 8px;
    padding: 12px 16px;
    margin-bottom: 1.5rem;
    font-size: 0.9rem;
}
.dev-mode-banner {
    background-color: #fff3cd;
    border: 1px solid #ffc107;
    border-radius: 8px;
    padding: 12px 16px;
    margin-bottom: 1.5rem;
    font-size: 0.9rem;
}
.dev-mode-banner .otp-code {
    font-size: 1.25rem;
    font-weight: 700;
    letter-spacing: 4px;
}
</style>
@endsection

@section('content')
<div class="position-relative">
    <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-6 mx-4">
            <div class="card p-sm-7 p-2">
                <div class="app-brand justify-content-center mt-5">
                    <a href="{{ url('/') }}" class="app-brand-link gap-3">
                        <span class="app-brand-logo demo">@include('_partials.macros')</span>
                        <span class="app-brand-text demo text-heading fw-semibold">{{ config('variables.templateName') }}</span>
                    </a>
                </div>

                <div class="card-body mt-1">
                    <h4 class="mb-1 text-center">Verify OTP</h4>
                    <p class="mb-3">We sent a verification code to your email address.</p>

                    <div class="otp-sent-banner mb-4">
                        <strong>OTP sent to your email address:</strong> {{ $maskedEmail ?? '' }}
                    </div>

                    @if (!empty($devOtp))
                    <div class="dev-mode-banner mb-4">
                        <strong class="d-block mb-1">Development mode</strong>
                        <span class="otp-code">{{ $devOtp }}</span>
                    </div>
                    @endif

                    @if (session('status'))
                        <div class="alert alert-success mb-3">{{ session('status') }}</div>
                    @endif
                    @if (session('error'))
                        <div class="alert alert-danger mb-3">{{ session('error') }}</div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger mb-3">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form id="formVerifyOtp" class="mb-4" action="{{ route('user.verify-otp') }}" method="POST">
                        @csrf
                        <label class="form-label text-uppercase small fw-semibold d-block mb-3">Enter 6-digit OTP</label>
                        <div class="d-flex justify-content-between gap-2 mb-4 auth-input-wrapper">
                            @for ($i = 1; $i <= 6; $i++)
                                <input type="text" inputmode="numeric" maxlength="1" class="form-control auth-otp-input auth-input text-center" data-index="{{ $i }}" id="otp{{ $i }}" autocomplete="off" />
                            @endfor
                        </div>
                        <input type="hidden" name="otp" id="otpValue" value="" required />
                        <button class="btn btn-primary d-grid w-100 mb-3" type="submit" id="btnVerify">Verify OTP</button>
                    </form>

                    <p class="text-center mb-2">
                        <span>Didn't receive the code?</span>
                        <form action="{{ route('user.resend-otp') }}" method="POST" class="d-inline" id="formResend">
                            @csrf
                            <button type="submit" class="btn btn-link p-0 align-baseline" id="btnResend">Resend OTP</button>
                        </form>
                    </p>
                    <p class="text-center small text-muted mb-2">
                        <i class="ri-information-line"></i> Check your spam/junk folder if you don't see the email
                    </p>
                    <p class="text-center mb-0">
                        <a href="{{ route('user.login') }}" class="text-primary"><i class="ri-arrow-left-line"></i> Back to login</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('page-script')
<script>
(function() {
    const inputs = document.querySelectorAll('.auth-input');
    const hidden = document.getElementById('otpValue');
    const form = document.getElementById('formVerifyOtp');

    function updateHidden() {
        const val = Array.from(inputs).map(i => i.value).join('');
        hidden.value = val;
    }

    inputs.forEach((input, idx) => {
        input.addEventListener('input', function(e) {
            const v = this.value.replace(/\D/g, '');
            this.value = v.slice(-1);
            updateHidden();
            if (this.value && inputs[idx + 1]) inputs[idx + 1].focus();
        });
        input.addEventListener('keydown', function(e) {
            if (e.key === 'Backspace' && !this.value && inputs[idx - 1]) {
                inputs[idx - 1].focus();
            }
        });
        input.addEventListener('paste', function(e) {
            e.preventDefault();
            const pasted = (e.clipboardData?.getData('text') || '').replace(/\D/g, '').slice(0, 6);
            pasted.split('').forEach((ch, i) => {
                if (inputs[i]) inputs[i].value = ch;
            });
            updateHidden();
            if (inputs[pasted.length]) inputs[pasted.length].focus();
        });
    });

    form?.addEventListener('submit', function() {
        updateHidden();
    });

    if (inputs[0]) inputs[0].focus();
})();
</script>
@endsection
