@php
use App\Services\NotificationService;
$notificationService = app(NotificationService::class);
$counts = $notificationService->getCounts();
$unreadCount = $counts['unread'];
@endphp

<li class="nav-item dropdown-notifications navbar-dropdown dropdown me-2">
    <a class="nav-link dropdown-toggle hide-arrow" 
       href="javascript:void(0)" 
       data-bs-toggle="dropdown" 
       data-bs-auto-close="outside" 
       aria-expanded="false"
       id="notification-bell-trigger">
        <i class="ri-notification-3-line ri-22px"></i>
        @if($unreadCount > 0)
            <span class="badge rounded-pill bg-danger badge-dot badge-notifications" id="unread-badge">
                {{ $unreadCount > 99 ? '99+' : $unreadCount }}
            </span>
        @endif
    </a>

    <ul class="dropdown-menu dropdown-menu-end py-0 notification-dropdown" style="width: 320px;">
        <li class="dropdown-menu-header border-bottom">
            <div class="dropdown-header d-flex align-items-center py-3 px-4">
                <h5 class="mb-0 me-auto fw-semibold">Notifications</h5>
                @if($unreadCount > 0)
                    <span class="badge rounded-pill badge-dot bg-danger bg-label-danger" id="header-unread-count">{{ $unreadCount }} New</span>
                @endif
            </div>
        </li>

        <!-- Category counts only (no full list) - loaded when dropdown opens -->
        <li class="dropdown-notifications-list scrollable-container" style="max-height: 320px; overflow-y: auto;">
            <div id="notification-categories-container" class="p-3">
                <div class="text-center py-4 text-muted" id="notification-categories-loading">
                    <span class="spinner-border spinner-border-sm me-2"></span>Loading…
                </div>
                <ul class="list-unstyled mb-0 d-none" id="notification-categories-list"></ul>
                <div class="text-center py-4 text-muted d-none" id="notification-categories-empty">
                    <i class="ri-notification-off-line mb-2" style="font-size: 2rem;"></i>
                    <p class="mb-0 small">No notifications</p>
                </div>
            </div>
        </li>

        <li class="dropdown-menu-footer border-top">
            <div class="d-grid gap-2 p-3">
                <button type="button" class="btn btn-sm btn-label-secondary" id="notification-mark-all-read">
                    <i class="ri-check-double-line me-1"></i>Mark all as read
                </button>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-sm btn-primary">
                    <i class="ri-arrow-right-line me-1"></i>View all notifications
                </a>
            </div>
        </li>
    </ul>
</li>

@php
function getCategoryIcon($type) {
    return match($type) {
        'agreement_expiring' => 'ri-file-text-line',
        'rent_due' => 'ri-calendar-line',
        'rent_overdue' => 'ri-alert-line',
        'deposit_low' => 'ri-money-dollar-circle-line',
        'student_pending' => 'ri-user-add-line',
        default => 'ri-notification-line',
    };
}
function getCategoryClass($type) {
    return match($type) {
        'rent_overdue', 'deposit_low' => 'bg-label-danger',
        'agreement_expiring', 'rent_due', 'student_pending' => 'bg-label-warning',
        default => 'bg-label-secondary',
    };
}
@endphp

<style>
.notification-dropdown { box-shadow: 0 0.375rem 1.5rem 0 rgba(140, 152, 164, 0.175); border: none; }
.notification-category-item {
    padding: 0.625rem 0;
    border-bottom: 1px solid rgba(67, 89, 113, 0.08);
    display: flex;
    align-items: center;
    gap: 0.75rem;
    text-decoration: none;
    color: inherit;
    transition: background 0.15s ease;
}
.notification-category-item:last-child { border-bottom: none; }
.notification-category-item:hover { background-color: rgba(67, 89, 113, 0.05); color: inherit; }
.badge-notifications { position: absolute; top: 0.125rem; right: 0.125rem; padding: 0.25rem 0.4rem; font-size: 0.625rem; font-weight: 600; }
.scrollable-container::-webkit-scrollbar { width: 6px; }
.scrollable-container::-webkit-scrollbar-thumb { background-color: rgba(67, 89, 113, 0.3); border-radius: 3px; }
</style>

<script>
(function() {
    const dropdownEl = document.querySelector('.dropdown-notifications');
    const container = document.getElementById('notification-categories-container');
    const loadingEl = document.getElementById('notification-categories-loading');
    const listEl = document.getElementById('notification-categories-list');
    const emptyEl = document.getElementById('notification-categories-empty');
    let loaded = false;

    function renderCategories(data) {
        loadingEl.classList.add('d-none');
        listEl.classList.add('d-none');
        emptyEl.classList.add('d-none');
        const categories = data.categories || [];
        if (categories.length === 0) {
            emptyEl.classList.remove('d-none');
            return;
        }
        const typeIcons = {
            'agreement_expiring': 'ri-file-text-line',
            'rent_due': 'ri-calendar-line',
            'rent_overdue': 'ri-alert-line',
            'deposit_low': 'ri-money-dollar-circle-line',
            'student_pending': 'ri-user-add-line'
        };
        const typeClasses = {
            'rent_overdue': 'bg-label-danger', 'deposit_low': 'bg-label-danger',
            'agreement_expiring': 'bg-label-warning', 'rent_due': 'bg-label-warning', 'student_pending': 'bg-label-warning'
        };
        listEl.innerHTML = categories.map(function(c) {
            const icon = typeIcons[c.type] || 'ri-notification-line';
            const cl = typeClasses[c.type] || 'bg-label-secondary';
            const count = c.count > 99 ? '99+' : c.count;
            return '<li><a href="{{ url("/admin/notifications") }}?filter=all" class="notification-category-item">' +
                '<span class="avatar avatar-sm"><span class="avatar-initial rounded-circle ' + cl + '"><i class="' + icon + '"></i></span></span>' +
                '<span class="flex-grow-1 fw-medium small">' + (c.label || c.type) + '</span>' +
                '<span class="badge rounded-pill bg-primary">' + count + '</span></a></li>';
        }).join('');
        listEl.classList.remove('d-none');
    }

    function loadNotificationCategories() {
        if (loaded) return;
        loaded = true;
        fetch('{{ route("admin.notifications.dropdown") }}', { headers: { 'Accept': 'application/json', 'X-Requested-With': 'XMLHttpRequest' } })
            .then(function(r) { return r.json(); })
            .then(function(data) {
                renderCategories(data);
                if (data.unread_count !== undefined) updateBadgeCount(data.unread_count);
            })
            .catch(function() {
                loadingEl.classList.add('d-none');
                emptyEl.classList.remove('d-none');
                emptyEl.querySelector('p').textContent = 'Failed to load';
            });
    }

    function updateBadgeCount(count) {
        const badge = document.getElementById('unread-badge');
        const headerCount = document.getElementById('header-unread-count');
        if (count > 0) {
            if (badge) { badge.textContent = count > 99 ? '99+' : count; badge.style.display = 'inline-flex'; }
            if (headerCount) { headerCount.textContent = count + ' New'; headerCount.style.display = 'inline'; }
        } else {
            if (badge) badge.style.display = 'none';
            if (headerCount) headerCount.style.display = 'none';
        }
    }

    if (dropdownEl) {
        dropdownEl.addEventListener('show.bs.dropdown', loadNotificationCategories);
    }

    document.getElementById('notification-mark-all-read').addEventListener('click', function() {
        fetch('{{ url("/admin/notifications/mark-all-as-read") }}', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content }
        })
        .then(function(r) { return r.json(); })
        .then(function(data) {
            if (data.success) {
                updateBadgeCount(0);
                document.querySelectorAll('.notification-category-item').forEach(function(el) { el.remove(); });
                document.getElementById('notification-categories-loading').classList.add('d-none');
                document.getElementById('notification-categories-empty').classList.remove('d-none');
                document.getElementById('notification-categories-list').classList.add('d-none');
            }
        })
        .catch(function(e) { console.error(e); });
    });
})();
</script>
