@props([
    'shareUrl' => '',
    'shareTitle' => 'Document',
    'pdfDownloadUrl' => '',
    'emailType' => '',
    'emailId' => '',
])

@php
    $pdfDownloadUrl = $pdfDownloadUrl ?: ($shareUrl ?? '');
    $hasPdf = (bool) $pdfDownloadUrl;
    $hasEmail = (bool) $emailType && (bool) $emailId;
@endphp

@if($hasPdf || $hasEmail)
<div class="dropdown no-print d-inline-block">
    <button type="button" class="btn btn-sm btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
        <i class="ri-share-line me-1"></i>Share
    </button>
    <ul class="dropdown-menu dropdown-menu-end">
        @if($hasPdf)
            <li>
                <a class="dropdown-item" href="{{ $pdfDownloadUrl }}" target="_blank" rel="noopener">
                    <i class="ri-file-pdf-line me-2 text-danger"></i>Download PDF
                </a>
            </li>
        @endif
        @if($hasEmail)
            <li>
                <a class="dropdown-item share-send-email-file" href="#" data-email-type="{{ $emailType }}" data-email-id="{{ $emailId }}" data-csrf="{{ csrf_token() }}" data-route="{{ route('admin.share.send-email') }}">
                    <i class="ri-mail-send-line me-2 text-primary"></i>Send via Email
                </a>
            </li>
        @endif
    </ul>
</div>
@endif

@if($hasEmail)
<script>
document.addEventListener('click', function(e) {
    var el = e.target.closest('.share-send-email-file');
    if (!el) return;
    e.preventDefault();
    var email = prompt('Enter email address to send the document (PDF file):');
    if (!email || !email.trim()) return;
    var route = el.dataset.route;
    var csrf = el.dataset.csrf || (document.querySelector('meta[name="csrf-token"]') && document.querySelector('meta[name="csrf-token"]').content);
    fetch(route, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json', 'Accept': 'application/json', 'X-CSRF-TOKEN': csrf },
        body: JSON.stringify({ type: el.dataset.emailType, id: parseInt(el.dataset.emailId, 10), email: email.trim() })
    }).then(function(r) { return r.json(); }).then(function(d) {
        if (d.success) alert('Document sent to ' + email.trim());
        else alert(d.message || 'Failed to send');
    }).catch(function() { alert('Failed to send'); });
}, true);
</script>
@endif
