@extends('layouts/contentNavbarLayout')

@section('title', 'Menu Management')

@section('vendor-style')
<link rel="stylesheet" href="{{ asset('assets/vendor/libs/sweetalert2/sweetalert2.css') }}" />
<style>
/* Main Layout */
.menu-management-container {
    display: flex;
    gap: 1.5rem;
    min-height: calc(100vh - 200px);
}

/* Left Sidebar - Menu List */
.menu-list-sidebar {
    width: 380px;
    background: #fff;
    border-radius: 0.5rem;
    box-shadow: 0 2px 6px rgba(0,0,0,0.08);
    display: flex;
    flex-direction: column;
    max-height: calc(100vh - 200px);
}

.menu-list-header {
    padding: 1.25rem;
    border-bottom: 1px solid #e7e7e7;
    background: #f8f9fa;
    border-radius: 0.5rem 0.5rem 0 0;
}

.menu-list-header h5 {
    margin: 0;
    font-size: 1rem;
    font-weight: 600;
    color: #566a7f;
}

.menu-search-box {
    padding: 1rem 1.25rem;
    border-bottom: 1px solid #e7e7e7;
}

.menu-items-list {
    flex: 1;
    overflow-y: auto;
    padding: 0.5rem;
}

.menu-item-card {
    padding: 1rem;
    border: 1px solid #e7e7e7;
    border-radius: 0.375rem;
    margin-bottom: 0.5rem;
    cursor: pointer;
    transition: all 0.2s;
    background: #fff;
}

.menu-item-card:hover {
    border-color: #696cff;
    background: #f8f9fa;
}

.menu-item-card.active {
    border-color: #696cff;
    background: #f0f2ff;
    border-width: 2px;
}

.menu-item-title {
    font-weight: 600;
    color: #566a7f;
    margin-bottom: 0.25rem;
    font-size: 0.9375rem;
}

.menu-item-badges {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.menu-item-badge {
    padding: 0.125rem 0.5rem;
    border-radius: 0.25rem;
    font-size: 0.75rem;
    font-weight: 500;
}

/* Right Panel - Menu Details */
.menu-detail-panel {
    flex: 1;
    background: #fff;
    border-radius: 0.5rem;
    box-shadow: 0 2px 6px rgba(0,0,0,0.08);
    overflow: hidden;
    max-height: calc(100vh - 200px);
    display: flex;
    flex-direction: column;
}

.menu-detail-header {
    padding: 1.25rem;
    border-bottom: 1px solid #e7e7e7;
    background: #f8f9fa;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.menu-detail-title {
    font-size: 1.125rem;
    font-weight: 600;
    color: #566a7f;
    margin: 0;
}

.menu-detail-content {
    flex: 1;
    overflow-y: auto;
    padding: 1.5rem;
}

.menu-info-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.menu-info-item {
    padding: 0.75rem;
    background: #f8f9fa;
    border-radius: 0.375rem;
    border-left: 3px solid #696cff;
}

.menu-info-label {
    font-size: 0.75rem;
    color: #8592a3;
    text-transform: uppercase;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.menu-info-value {
    font-size: 0.9375rem;
    color: #566a7f;
    font-weight: 500;
}

.menu-link-section {
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 0.375rem;
    margin-bottom: 1.5rem;
}

.menu-link-label {
    font-size: 0.8125rem;
    color: #8592a3;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.menu-link-value {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 0.75rem;
    background: #fff;
    border-radius: 0.25rem;
    border: 1px solid #d9dee3;
}

.menu-link-icon {
    color: #696cff;
}

/* Submenus Section */
.submenus-section {
    margin-top: 1.5rem;
}

.submenus-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.submenus-title {
    font-size: 1rem;
    font-weight: 600;
    color: #566a7f;
    margin: 0;
}

.submenu-item {
    border: 1px solid #e7e7e7;
    border-radius: 0.375rem;
    margin-bottom: 0.75rem;
    background: #fff;
    transition: all 0.2s;
}

.submenu-item:hover {
    box-shadow: 0 2px 4px rgba(0,0,0,0.08);
}

.submenu-header {
    padding: 1rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
    cursor: pointer;
    user-select: none;
}

.submenu-expand-btn {
    background: none;
    border: none;
    color: #8592a3;
    padding: 0;
    font-size: 1.25rem;
    cursor: pointer;
    transition: transform 0.2s;
    line-height: 1;
}

.submenu-expand-btn.expanded {
    transform: rotate(90deg);
}

.submenu-info {
    flex: 1;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.submenu-title-block {
    flex: 1;
}

.submenu-title {
    font-weight: 600;
    color: #566a7f;
    margin-bottom: 0.25rem;
    font-size: 0.9375rem;
}

.submenu-subtitle {
    font-size: 0.8125rem;
    color: #8592a3;
}

.submenu-badges {
    display: flex;
    gap: 0.5rem;
}

.submenu-actions {
    display: flex;
    gap: 0.25rem;
}

.submenu-nested-list {
    padding: 0 1rem 1rem 2.5rem;
    border-top: 1px solid #f0f0f0;
    background: #fafafa;
    display: none;
}

.submenu-nested-list.show {
    display: block;
}

.nested-submenu-item {
    padding: 0.75rem;
    border-left: 2px solid #696cff;
    background: #fff;
    margin-top: 0.5rem;
    border-radius: 0.25rem;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 3rem 2rem;
}

.empty-state-icon {
    font-size: 3rem;
    color: #d9dee3;
    margin-bottom: 1rem;
}

.empty-state-text {
    color: #8592a3;
    font-size: 0.9375rem;
}

/* Badges */
.badge-order {
    background: #696cff;
    color: #fff;
}

.badge-type-custom {
    background: #03c3ec;
    color: #fff;
}

.badge-type-url {
    background: #8592a3;
    color: #fff;
}

.badge-type-placeholder {
    background: #ffab00;
    color: #fff;
}

.badge-status-active {
    background: #71dd37;
    color: #fff;
}

.badge-status-inactive {
    background: #d9dee3;
    color: #566a7f;
}

.badge-nesting {
    background: #ff3e1d;
    color: #fff;
}

/* Responsive */
@media (max-width: 991px) {
    .menu-management-container {
        flex-direction: column;
    }
    
    .menu-list-sidebar {
        width: 100%;
        max-height: 400px;
    }
    
    .menu-info-grid {
        grid-template-columns: 1fr;
    }
}

/* Scrollbar Styling */
.menu-items-list::-webkit-scrollbar,
.menu-detail-content::-webkit-scrollbar {
    width: 6px;
}

.menu-items-list::-webkit-scrollbar-track,
.menu-detail-content::-webkit-scrollbar-track {
    background: #f0f0f0;
}

.menu-items-list::-webkit-scrollbar-thumb,
.menu-detail-content::-webkit-scrollbar-thumb {
    background: #d9dee3;
    border-radius: 3px;
}

.menu-items-list::-webkit-scrollbar-thumb:hover,
.menu-detail-content::-webkit-scrollbar-thumb:hover {
    background: #8592a3;
}
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0">Menu Management</h4>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addMenuModal">
            <i class="ri-add-line me-1"></i>Add Menu
        </button>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger alert-dismissible">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Main Layout: Split Panel -->
    <div class="menu-management-container">
        <!-- Left Sidebar: Menu List -->
        <div class="menu-list-sidebar">
            <div class="menu-list-header">
                <h5>All Menus</h5>
            </div>
            
            <div class="menu-search-box">
                <input type="text" id="menuSearchInput" class="form-control form-control-sm" placeholder="Search menus...">
            </div>

            <div class="menu-items-list" id="menuItemsList">
                @forelse($menus as $menu)
                    @php
                        $submenus = !empty($menu->submenus) ? (is_string($menu->submenus) ? json_decode($menu->submenus, true) : $menu->submenus) : [];
                        $countNestedSubmenus = function($items) use (&$countNestedSubmenus) {
                            $count = count($items);
                            foreach ($items as $item) {
                                if (isset($item['submenus']) && is_array($item['submenus'])) {
                                    $count += $countNestedSubmenus($item['submenus']);
                                }
                            }
                            return $count;
                        };
                        $totalSubmenuCount = $countNestedSubmenus($submenus);
                    @endphp
                    
                    <div class="menu-item-card {{ $loop->first ? 'active' : '' }}" 
                         data-menu-id="{{ $menu->id }}"
                         data-menu-data='@json($menu)'>
                        <div class="menu-item-title">{{ $menu->title }}</div>
                        <div class="menu-item-subtitle text-muted small">{{ $menu->title_text }}</div>
                        <div class="menu-item-badges mt-2">
                            <span class="menu-item-badge badge-order">{{ $menu->order }}</span>
                            @if($menu->link_type === 'custom_page')
                                <span class="menu-item-badge badge-type-custom">PAGE</span>
                            @elseif($menu->link_type === 'link_url')
                                <span class="menu-item-badge badge-type-url">LINK</span>
                            @else
                                <span class="menu-item-badge badge-type-placeholder">PLACEHOLDER</span>
                            @endif
                            @if($totalSubmenuCount > 0)
                                <span class="menu-item-badge badge-nesting">{{ $totalSubmenuCount }} SUBS</span>
                            @endif
                        </div>
                    </div>
                @empty
                    <div class="empty-state">
                        <div class="empty-state-icon">
                            <i class="ri-menu-line"></i>
                        </div>
                        <p class="empty-state-text">No menus yet. Add your first menu!</p>
                    </div>
                @endforelse
            </div>
        </div>

        <!-- Right Panel: Menu Details -->
        <div class="menu-detail-panel" id="menuDetailPanel">
            @if(is_array($menus) ? !empty($menus) : $menus->isNotEmpty())
                @php
                    $firstMenu = is_array($menus) ? reset($menus) : $menus->first();
                    $submenus = !empty($firstMenu->submenus) ? (is_string($firstMenu->submenus) ? json_decode($firstMenu->submenus, true) : $firstMenu->submenus) : [];
                @endphp
                
                <div class="menu-detail-header">
                    <h4 class="menu-detail-title">{{ $firstMenu->title }} ({{ $firstMenu->title_text }})</h4>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="menuActiveSwitch" 
                               {{ $firstMenu->is_active ? 'checked' : '' }}
                               data-menu-id="{{ $firstMenu->id }}">
                        <label class="form-check-label" for="menuActiveSwitch">
                            <span class="badge {{ $firstMenu->is_active ? 'bg-success' : 'bg-secondary' }}">
                                {{ $firstMenu->is_active ? 'ACTIVE' : 'INACTIVE' }}
                            </span>
                        </label>
                    </div>
                </div>

                <div class="menu-detail-content">
                    <!-- Menu Info Grid -->
                    <div class="menu-info-grid">
                        <div class="menu-info-item">
                            <div class="menu-info-label">Order</div>
                            <div class="menu-info-value">{{ $firstMenu->order }}</div>
                        </div>
                        <div class="menu-info-item">
                            <div class="menu-info-label">Link Type</div>
                            <div class="menu-info-value">{{ strtoupper(str_replace('_', ' ', $firstMenu->link_type)) }}</div>
                        </div>
                        <div class="menu-info-item">
                            <div class="menu-info-label">Status</div>
                            <div class="menu-info-value">{{ $firstMenu->is_active ? 'Active' : 'Inactive' }}</div>
                        </div>
                    </div>

                    <!-- Link Section -->
                    @if($firstMenu->link_type !== 'placeholder')
                        <div class="menu-link-section">
                            <div class="menu-link-label">Link</div>
                            <div class="menu-link-value">
                                <i class="ri-link menu-link-icon"></i>
                                <span>
                                    @if($firstMenu->link_type === 'custom_page')
                                        page/{{ $firstMenu->custom_page }}
                                    @else
                                        {{ $firstMenu->link_url }}
                                    @endif
                                </span>
                            </div>
                        </div>
                    @endif

                    <!-- Submenus Section -->
                    <div class="submenus-section">
                        <div class="submenus-header">
                            <h5 class="submenus-title">Submenus ({{ count($submenus) }})</h5>
                            <button type="button" class="btn btn-sm btn-primary add-submenu-btn" 
                                    data-menu-id="{{ $firstMenu->id }}"
                                    data-menu-name="{{ $firstMenu->title_text }}">
                                <i class="ri-add-line me-1"></i>Add Nested Submenu
                            </button>
                        </div>

                        <div id="submenusList">
                            @forelse($submenus as $index => $submenu)
                                @include('content.admin.menu_management.partials.submenu-detail-item', [
                                    'submenu' => $submenu,
                                    'menuId' => $firstMenu->id,
                                    'menuTitle' => $firstMenu->title_text,
                                    'path' => (string)$index,
                                    'level' => 1
                                ])
                            @empty
                                <div class="empty-state">
                                    <div class="empty-state-icon">
                                        <i class="ri-folder-line"></i>
                                    </div>
                                    <p class="empty-state-text">No submenus yet. Add your first submenu!</p>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="d-flex gap-2 mt-4">
                        <button type="button" class="btn btn-outline-secondary edit-main-menu-btn" 
                                data-menu-id="{{ $firstMenu->id }}"
                                data-bs-toggle="modal" 
                                data-bs-target="#editMenuModal{{ $firstMenu->id }}">
                            <i class="ri-edit-line me-1"></i>Edit Menu
                        </button>
                        <button type="button" class="btn btn-outline-danger delete-main-menu-btn" 
                                data-menu-id="{{ $firstMenu->id }}"
                                data-menu-title="{{ $firstMenu->title_text }}">
                            <i class="ri-delete-bin-line me-1"></i>Delete Menu
                        </button>
                    </div>
                </div>

                <!-- Edit Menu Modal -->
                <div class="modal fade" id="editMenuModal{{ $firstMenu->id }}" tabindex="-1">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <form action="{{ route('admin.content-menu_management-update') }}" method="POST">
                                @csrf
                                <input type="hidden" name="id" value="{{ $firstMenu->id }}">
                                <div class="modal-header">
                                    <h5 class="modal-title">Edit Menu</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="mb-3">
                                        <label class="form-label">Menu Key <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="title" value="{{ $firstMenu->title }}" required>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Display Text <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="title_text" value="{{ $firstMenu->title_text }}" required>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Link Type <span class="text-danger">*</span></label>
                                        <select class="form-select link-type-select" name="main_link_type" required>
                                            <option value="custom_page" {{ $firstMenu->link_type === 'custom_page' ? 'selected' : '' }}>Custom Page</option>
                                            <option value="link_url" {{ $firstMenu->link_type === 'link_url' ? 'selected' : '' }}>External URL</option>
                                            <option value="placeholder" {{ $firstMenu->link_type === 'placeholder' ? 'selected' : '' }}>Placeholder</option>
                                        </select>
                                    </div>
                                    <div class="mb-3 custom-page-field" style="display: {{ $firstMenu->link_type === 'custom_page' ? 'block' : 'none' }};">
                                        <label class="form-label">Custom Page</label>
                                        <select class="form-select" name="main_custom_page">
                                            <option value="">Select Page</option>
                                            @foreach($customPages as $page)
                                                <option value="{{ $page->page_slug }}" {{ $firstMenu->custom_page === $page->page_slug ? 'selected' : '' }}>{{ $page->page_slug }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="mb-3 link-url-field" style="display: {{ $firstMenu->link_type === 'link_url' ? 'block' : 'none' }};">
                                        <label class="form-label">External URL</label>
                                        <input type="url" class="form-control" name="main_link_url" value="{{ $firstMenu->link_url }}">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Display Order <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control" name="main_order" value="{{ $firstMenu->order }}" min="1" required>
                                    </div>
                                    <div class="mb-3">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" name="is_active" {{ $firstMenu->is_active ? 'checked' : '' }}>
                                            <label class="form-check-label">Active</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                                    <button type="submit" class="btn btn-primary">Update Menu</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            @else
                <div class="empty-state">
                    <div class="empty-state-icon">
                        <i class="ri-menu-line"></i>
                    </div>
                    <p class="empty-state-text">Select a menu from the left to view details</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Add Menu Modal -->
<div class="modal fade" id="addMenuModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.content-menu_management-store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Add New Menu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Menu Key <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('title') is-invalid @enderror" name="title" value="{{ old('title') }}" required placeholder="e.g., dashboard">
                        @error('title')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Display Text <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('title_text') is-invalid @enderror" name="title_text" value="{{ old('title_text') }}" required placeholder="e.g., Dashboard">
                        @error('title_text')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Link Type <span class="text-danger">*</span></label>
                        <select class="form-select link-type-select @error('main_link_type') is-invalid @enderror" name="main_link_type" required>
                            <option value="">Select Link Type</option>
                            <option value="custom_page" {{ old('main_link_type') === 'custom_page' ? 'selected' : '' }}>Custom Page</option>
                            <option value="link_url" {{ old('main_link_type') === 'link_url' ? 'selected' : '' }}>External URL</option>
                            <option value="placeholder" {{ old('main_link_type') === 'placeholder' ? 'selected' : '' }}>Placeholder</option>
                        </select>
                        @error('main_link_type')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3 custom-page-field" style="display: none;">
                        <label class="form-label">Custom Page</label>
                        <select class="form-select @error('main_custom_page') is-invalid @enderror" name="main_custom_page">
                            <option value="">Select Page</option>
                            @foreach($customPages as $page)
                                <option value="{{ $page->page_slug }}" {{ old('main_custom_page') === $page->page_slug ? 'selected' : '' }}>{{ $page->page_slug }}</option>
                            @endforeach
                        </select>
                        @error('main_custom_page')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3 link-url-field" style="display: none;">
                        <label class="form-label">External URL</label>
                        <input type="url" class="form-control @error('main_link_url') is-invalid @enderror" name="main_link_url" value="{{ old('main_link_url') }}" placeholder="https://example.com">
                        @error('main_link_url')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Display Order <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('main_order') is-invalid @enderror" name="main_order" value="{{ old('main_order', (is_array($menus) ? count($menus) : $menus->count()) + 1) }}" min="1" required>
                        @error('main_order')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" checked>
                            <label class="form-check-label" for="is_active">Active</label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Menu</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Submenu Modal -->
<div class="modal fade" id="addSubmenuModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="addSubmenuForm">
                <input type="hidden" id="submenu_parent_id" name="parent_id">
                <input type="hidden" id="submenu_parent_path" name="parent_path">
                <div class="modal-header">
                    <h5 class="modal-title">Add Submenu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info mb-3">
                        <small><strong>Parent:</strong> <span id="parent_menu_name"></span></small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Submenu Key <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="submenu_title" name="title" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Display Text <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="submenu_title_text" name="title_text" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Link Type <span class="text-danger">*</span></label>
                        <select class="form-select submenu-link-type-select" id="submenu_link_type" name="link_type" required>
                            <option value="">Select Link Type</option>
                            <option value="custom_page">Custom Page</option>
                            <option value="link_url">External URL</option>
                            <option value="placeholder">Placeholder</option>
                        </select>
                    </div>
                    <div class="mb-3 submenu-custom-page-field" style="display: none;">
                        <label class="form-label">Custom Page</label>
                        <select class="form-select" id="submenu_custom_page" name="custom_page">
                            <option value="">Select Page</option>
                            @foreach($customPages as $page)
                                <option value="{{ $page->page_slug }}">{{ $page->page_slug }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3 submenu-link-url-field" style="display: none;">
                        <label class="form-label">External URL</label>
                        <input type="url" class="form-control" id="submenu_link_url" name="link_url" placeholder="https://example.com">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="saveSubmenuBtn">Add Submenu</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('vendor-script')
<script src="{{ asset('assets/vendor/libs/sweetalert2/sweetalert2.js') }}"></script>
@endsection

@section('page-script')
<script>
$(document).ready(function() {
    'use strict';

    const CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
    const BASE_URL = '/admin/content/menu_management';

    // Helper: Show toast notification
    function showToast(message, icon = 'success') {
        Swal.fire({
            toast: true,
            position: 'top-end',
            icon: icon,
            title: message,
            showConfirmButton: false,
            timer: 3000
        });
    }

    // Toggle link type fields
    $(document).on('change', '.link-type-select, .submenu-link-type-select', function() {
        const $form = $(this).closest('form, .modal-body');
        const linkType = $(this).val();
        
        $form.find('.custom-page-field, .submenu-custom-page-field').hide();
        $form.find('.link-url-field, .submenu-link-url-field').hide();

        if (linkType === 'custom_page') {
            $form.find('.custom-page-field, .submenu-custom-page-field').show();
        } else if (linkType === 'link_url') {
            $form.find('.link-url-field, .submenu-link-url-field').show();
        }
    });

    // Menu item click - load details
    $(document).on('click', '.menu-item-card', function() {
        const menuId = $(this).data('menu-id');
        
        // Update active state
        $('.menu-item-card').removeClass('active');
        $(this).addClass('active');

        // Load menu details via AJAX
        $.ajax({
            url: `${BASE_URL}/get/${menuId}`,
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    location.reload(); // Reload to show selected menu
                }
            },
            error: function() {
                showToast('Failed to load menu details', 'error');
            }
        });
    });

    // Toggle submenu expand/collapse
    $(document).on('click', '.submenu-expand-btn', function(e) {
        e.stopPropagation();
        $(this).toggleClass('expanded');
        $(this).closest('.submenu-item').find('.submenu-nested-list').first().toggleClass('show');
    });

    // Toggle menu active status
    $(document).on('change', '#menuActiveSwitch', function() {
        const menuId = $(this).data('menu-id');
        const isActive = $(this).is(':checked');

        $.ajax({
            url: `${BASE_URL}/status`,
            method: 'PUT',
            headers: { 'X-CSRF-TOKEN': CSRF_TOKEN },
            data: { 
                id: menuId,
                is_active: isActive ? 1 : 0
            },
            success: function(response) {
                if (response.success) {
                    showToast('Menu status updated!', 'success');
                    const $badge = $('#menuActiveSwitch').next().find('.badge');
                    if (isActive) {
                        $badge.removeClass('bg-secondary').addClass('bg-success').text('ACTIVE');
                    } else {
                        $badge.removeClass('bg-success').addClass('bg-secondary').text('INACTIVE');
                    }
                }
            },
            error: function() {
                showToast('Failed to update status', 'error');
                $('#menuActiveSwitch').prop('checked', !isActive);
            }
        });
    });

    // Delete main menu
    $(document).on('click', '.delete-main-menu-btn', function() {
        const menuId = $(this).data('menu-id');
        const menuTitle = $(this).data('menu-title');

        Swal.fire({
            title: 'Delete Menu?',
            text: `Delete "${menuTitle}" and all its submenus?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `${BASE_URL}/delete`,
                    method: 'DELETE',
                    headers: { 'X-CSRF-TOKEN': CSRF_TOKEN },
                    data: { id: menuId },
                    success: function(response) {
                        if (response.success) {
                            showToast('Menu deleted successfully!', 'success');
                            setTimeout(() => location.reload(), 1000);
                        }
                    },
                    error: function() {
                        showToast('Failed to delete menu', 'error');
                    }
                });
            }
        });
    });

    // Add submenu
    $(document).on('click', '.add-submenu-btn', function() {
        const menuId = $(this).data('menu-id');
        const menuName = $(this).data('menu-name');
        const parentPath = $(this).data('parent-path') || '';

        $('#submenu_parent_id').val(menuId);
        $('#submenu_parent_path').val(parentPath);
        $('#parent_menu_name').text(menuName);
        $('#addSubmenuForm')[0].reset();
        $('#addSubmenuModal').modal('show');
    });

    // Save submenu
    $('#saveSubmenuBtn').on('click', function() {
        const formData = {
            parent_id: $('#submenu_parent_id').val(),
            parent_path: $('#submenu_parent_path').val(),
            title: $('#submenu_title').val(),
            title_text: $('#submenu_title_text').val(),
            link_type: $('#submenu_link_type').val()
        };

        if (formData.link_type === 'custom_page') {
            formData.custom_page = $('#submenu_custom_page').val();
        } else if (formData.link_type === 'link_url') {
            formData.link_url = $('#submenu_link_url').val();
        }

        $.ajax({
            url: `${BASE_URL}/quick-add-submenu`,
            method: 'POST',
            headers: { 'X-CSRF-TOKEN': CSRF_TOKEN },
            data: formData,
            success: function(response) {
                if (response.success) {
                    $('#addSubmenuModal').modal('hide');
                    showToast('Submenu added successfully!', 'success');
                    setTimeout(() => location.reload(), 1000);
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || 'Failed to add submenu';
                showToast(message, 'error');
            }
        });
    });

    // Delete submenu
    $(document).on('click', '.delete-submenu-btn', function() {
        const parentId = $(this).data('parent-id');
        const submenuPath = $(this).data('submenu-path');
        const submenuTitle = $(this).data('submenu-title');

        Swal.fire({
            title: 'Delete Submenu?',
            text: `Delete "${submenuTitle}"?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `${BASE_URL}/delete-submenu`,
                    method: 'POST',
                    headers: { 'X-CSRF-TOKEN': CSRF_TOKEN },
                    data: {
                        parent_id: parentId,
                        submenu_path: submenuPath
                    },
                    success: function(response) {
                        if (response.success) {
                            showToast('Submenu deleted successfully!', 'success');
                            setTimeout(() => location.reload(), 1000);
                        }
                    },
                    error: function() {
                        showToast('Failed to delete submenu', 'error');
                    }
                });
            }
        });
    });

    // Edit submenu
    $(document).on('click', '.edit-submenu-btn', function(e) {
        e.stopPropagation();
        const parentId = $(this).data('parent-id');
        const submenuPath = $(this).data('submenu-path');
        const title = $(this).data('title');
        const titleText = $(this).data('title-text');
        const linkType = $(this).data('link-type');
        const customPage = $(this).data('custom-page');
        const linkUrl = $(this).data('link-url');

        Swal.fire({
            title: 'Edit Submenu',
            html: `
                <div class="text-start">
                    <div class="mb-3">
                        <label class="form-label">Submenu Key</label>
                        <input type="text" id="edit_submenu_title" class="form-control" value="${title}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Display Text</label>
                        <input type="text" id="edit_submenu_title_text" class="form-control" value="${titleText}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Link Type</label>
                        <select id="edit_submenu_link_type" class="form-select">
                            <option value="custom_page" ${linkType === 'custom_page' ? 'selected' : ''}>Custom Page</option>
                            <option value="link_url" ${linkType === 'link_url' ? 'selected' : ''}>External URL</option>
                            <option value="placeholder" ${linkType === 'placeholder' ? 'selected' : ''}>Placeholder</option>
                        </select>
                    </div>
                    <div class="mb-3" id="edit_custom_page_div" style="display: ${linkType === 'custom_page' ? 'block' : 'none'};">
                        <label class="form-label">Custom Page</label>
                        <select id="edit_submenu_custom_page" class="form-select">
                            <option value="">Select Page</option>
                            @foreach($customPages as $page)
                                <option value="{{ $page->page_slug }}" ${customPage === '{{ $page->page_slug }}' ? 'selected' : ''}>{{ $page->page_slug }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3" id="edit_link_url_div" style="display: ${linkType === 'link_url' ? 'block' : 'none'};">
                        <label class="form-label">External URL</label>
                        <input type="url" id="edit_submenu_link_url" class="form-control" value="${linkUrl}">
                    </div>
                </div>
            `,
            width: '500px',
            showCancelButton: true,
            confirmButtonText: 'Update',
            cancelButtonText: 'Cancel',
            didOpen: () => {
                $('#edit_submenu_link_type').on('change', function() {
                    const type = $(this).val();
                    $('#edit_custom_page_div').toggle(type === 'custom_page');
                    $('#edit_link_url_div').toggle(type === 'link_url');
                });
            },
            preConfirm: () => {
                const editLinkType = $('#edit_submenu_link_type').val();
                return {
                    title: $('#edit_submenu_title').val(),
                    title_text: $('#edit_submenu_title_text').val(),
                    link_type: editLinkType,
                    custom_page: editLinkType === 'custom_page' ? $('#edit_submenu_custom_page').val() : null,
                    link_url: editLinkType === 'link_url' ? $('#edit_submenu_link_url').val() : null
                };
            }
        }).then((result) => {
            if (result.isConfirmed) {
                const updateData = {
                    parent_id: parentId,
                    submenu_path: submenuPath,
                    ...result.value
                };

                $.ajax({
                    url: `${BASE_URL}/update-submenu`,
                    method: 'POST',
                    headers: { 'X-CSRF-TOKEN': CSRF_TOKEN },
                    data: updateData,
                    success: function(response) {
                        if (response.success) {
                            showToast('Submenu updated successfully!', 'success');
                            setTimeout(() => location.reload(), 1000);
                        }
                    },
                    error: function() {
                        showToast('Failed to update submenu', 'error');
                    }
                });
            }
        });
    });

    // Duplicate submenu
    $(document).on('click', '.duplicate-submenu-btn', function(e) {
        e.stopPropagation();
        const parentId = $(this).data('parent-id');
        const submenuPath = $(this).data('submenu-path');

        Swal.fire({
            title: 'Duplicate Submenu?',
            text: 'Create a copy of this submenu?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Yes, duplicate it!'
        }).then((result) => {
            if (result.isConfirmed) {
                showToast('Duplicate feature coming soon!', 'info');
                // TODO: Implement duplicate functionality
            }
        });
    });

    // Search menus
    $('#menuSearchInput').on('keyup', function() {
        const searchTerm = $(this).val().toLowerCase();
        
        $('.menu-item-card').each(function() {
            const title = $(this).find('.menu-item-title').text().toLowerCase();
            const subtitle = $(this).find('.menu-item-subtitle').text().toLowerCase();
            
            if (title.includes(searchTerm) || subtitle.includes(searchTerm)) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });

    // Initialize
    $('.link-type-select').each(function() {
        $(this).trigger('change');
    });
});

// Show add modal with errors
@if($errors->any() && old('title'))
document.addEventListener('DOMContentLoaded', function() {
    var modal = new bootstrap.Modal(document.getElementById('addMenuModal'));
    modal.show();
});
@endif
</script>
@endsection
