@php
use Illuminate\Support\Facades\Route;
$menu = $menuData[0]->menu ?? [];
$brandText = strtoupper(config('variables.templateName'));
@endphp

<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme sneat-sidebar">

  <!-- SNEAT (purple) + purple circle, separator below -->
  <div class="app-brand demo sneat-app-brand">
    <a href="{{ url('/') }}" class="app-brand-link">
      <span class="app-brand-logo demo me-1 sneat-logo-inline">@include('_partials.macros')</span>
      <span class="app-brand-text demo menu-text fw-bold ms-2">{{ $brandText }}</span>
    </a>
    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto sneat-sidebar-circle" aria-label="Toggle sidebar">
      <span class="sneat-circle-icon"></span>
    </a>
  </div>

  <div class="sneat-sidebar-divider"></div>
  <div class="menu-inner-shadow"></div>

  <ul class="menu-inner py-1">
    @foreach ($menu as $item)
      @if (isset($item->menuHeader))
        <li class="menu-header small text-uppercase">
          <span class="menu-header-text">{{ $item->menuHeader }}</span>
        </li>
      @else
        @php
          $hasSubmenu = isset($item->submenu) && count($item->submenu) > 0;
          $isRouteName = isset($item->url) && str_contains($item->url, '.') && !str_starts_with($item->url ?? '', 'http');
          $href = isset($item->url) ? ($isRouteName ? route($item->url) : url($item->url)) : 'javascript:void(0);';
          $activeClass = '';
          if ($hasSubmenu) {
            $slugForRoute = isset($item->slug) ? str_replace('-', '.', $item->slug) : '';
            if ($slugForRoute && request()->routeIs($slugForRoute . '.*')) {
              $activeClass = 'active open';
            }
          } else {
            if ($isRouteName && request()->routeIs($item->url)) {
              $activeClass = 'active';
            } elseif (isset($item->slug) && Route::currentRouteName() === $item->slug) {
              $activeClass = 'active';
            }
          }
        @endphp
        <li class="menu-item {{ $activeClass }}">
          <a href="{{ $href }}" class="{{ $hasSubmenu ? 'menu-link menu-toggle' : 'menu-link' }}" @if (isset($item->target) && $item->target) target="{{ $item->target }}" @endif>
            @if (isset($item->icon))
              <i class="{{ $item->icon }}"></i>
            @endif
            <div>{{ $item->name ?? '' }}</div>
            @isset($item->badge)
              <div class="badge bg-{{ $item->badge[0] }} rounded-pill ms-auto">{{ $item->badge[1] }}</div>
            @endisset
          </a>
          @if ($hasSubmenu)
            @include('layouts.sections.menu.submenu', ['menu' => $item->submenu])
          @endif
        </li>
      @endif
    @endforeach
  </ul>

</aside>
